/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level;

import org.geysermc.geyser.level.chunk.BlockStorage;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.level.chunk.bitarray.SingletonBitArray;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.ints.IntLists;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.BitStorage;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.DataPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.GlobalPalette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.Palette;
import org.geysermc.mcprotocollib.protocol.data.game.chunk.palette.SingletonPalette;

public class BiomeTranslator {
    public static int loadServerBiome(RegistryEntryContext entry) {
        String javaIdentifier = entry.id().asString();
        return ((Object2IntMap)Registries.BIOME_IDENTIFIERS.get()).getOrDefault((Object)javaIdentifier, 0);
    }

    public static BlockStorage toNewBedrockBiome(GeyserSession session, DataPalette biomeData) {
        BlockStorage storage;
        JavaRegistry<Integer> biomeTranslations = session.getRegistryCache().registry(JavaRegistries.BIOME);
        Palette palette = biomeData.getPalette();
        if (palette instanceof SingletonPalette) {
            int biomeId = biomeTranslations.byId(palette.idToState(0));
            return new BlockStorage(SingletonBitArray.INSTANCE, IntLists.singleton(biomeId));
        }
        if (!(palette instanceof GlobalPalette)) {
            int i;
            BitStorage bitStorage = biomeData.getStorage();
            int size = palette.size();
            BitArray bitArray = BitArrayVersion.forBitsCeil(bitStorage.getBitsPerEntry()).createArray(4096);
            IntArrayList bedrockPalette = new IntArrayList(size);
            for (i = 0; i < size; ++i) {
                int javaId = palette.idToState(i);
                bedrockPalette.add((int)biomeTranslations.byId(javaId));
            }
            for (i = 0; i < 64; ++i) {
                int idx = bitStorage.get(i);
                int x = i & 3;
                int y = i >> 4 & 3;
                int z = i >> 2 & 3;
                BiomeTranslator.multiplyIdToStorage(bitArray, idx, x, y, z);
            }
            storage = new BlockStorage(bitArray, bedrockPalette);
        } else {
            storage = new BlockStorage(0);
            for (int i = 0; i < 64; ++i) {
                int javaId = palette.idToState(biomeData.getStorage().get(i));
                int x = i & 3;
                int y = i >> 4 & 3;
                int z = i >> 2 & 3;
                int biomeId = biomeTranslations.byId(javaId);
                int idx = storage.idFor(biomeId);
                BiomeTranslator.multiplyIdToStorage(storage.getBitArray(), idx, x, y, z);
            }
        }
        return storage;
    }

    private static void multiplyIdToStorage(BitArray bitArray, int idx, int x, int y, int z) {
        for (int blockX = x << 2; blockX < (x << 2) + 4; ++blockX) {
            for (int blockZ = z << 2; blockZ < (z << 2) + 4; ++blockZ) {
                for (int blockY = y << 2; blockY < (y << 2) + 4; ++blockY) {
                    bitArray.set(blockX << 8 | blockZ << 4 | blockY, idx);
                }
            }
        }
    }
}

