/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.collision;

import lombok.Generated;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.translator.collision.CollisionRemapper;

@CollisionRemapper(regex="_trapdoor$", usesParams=true, passDefaultBoxes=true)
public class TrapdoorCollision
extends BlockCollision {
    private final Direction facing;

    public TrapdoorCollision(BlockState state, BoundingBox[] defaultBoxes) {
        super(defaultBoxes);
        this.facing = state.getValue(Properties.OPEN) != false ? state.getValue(Properties.HORIZONTAL_FACING) : (state.getValue(Properties.HALF).equals("bottom") ? Direction.UP : Direction.DOWN);
    }

    @Override
    public boolean correctPosition(GeyserSession session, int x, int y, int z, BoundingBox playerCollision) {
        boolean result = super.correctPosition(session, x, y, z, playerCollision);
        if (this.checkIntersection(x, y, z, playerCollision)) {
            switch (this.facing) {
                case NORTH: {
                    playerCollision.setMiddleZ((double)z + 0.5125);
                    break;
                }
                case EAST: {
                    playerCollision.setMiddleX((double)x + 0.5125);
                    break;
                }
                case SOUTH: {
                    playerCollision.setMiddleZ((double)z + 0.4875);
                    break;
                }
                case WEST: {
                    playerCollision.setMiddleX((double)x + 0.4875);
                    break;
                }
                case UP: {
                    break;
                }
                case DOWN: {
                    playerCollision.setMiddleY((double)(y + 1) - 0.1875 - playerCollision.getSizeY() / 2.0 - 1.0E-5);
                }
            }
        }
        return result;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrapdoorCollision)) {
            return false;
        }
        TrapdoorCollision other = (TrapdoorCollision)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Direction this$facing = this.facing;
        Direction other$facing = other.facing;
        return !(this$facing == null ? other$facing != null : !((Object)((Object)this$facing)).equals((Object)other$facing));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrapdoorCollision;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Direction $facing = this.facing;
        result = result * 59 + ($facing == null ? 43 : ((Object)((Object)$facing)).hashCode());
        return result;
    }
}

