/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog.input;

import java.util.Optional;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.geyser.platform.viaproxy.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.input.DialogInput;
import org.geysermc.geyser.session.dialog.input.DialogInputParseException;
import org.geysermc.geyser.util.MinecraftKey;

public class BooleanInput
extends DialogInput<Boolean> {
    public static final Key TYPE = MinecraftKey.key("boolean");
    private final boolean initial;
    private final String onTrue;
    private final String onFalse;

    public BooleanInput(Optional<GeyserSession> session, NbtMap map) {
        super(session, map);
        this.initial = map.getBoolean("initial", false);
        this.onTrue = map.getString("on_true", "true");
        this.onFalse = map.getString("on_false", "false");
    }

    @Override
    public void addComponent(CustomForm.Builder builder, Optional<Boolean> restored) {
        builder.toggle(this.label, restored.orElse(this.initial));
    }

    @Override
    public Boolean read(CustomFormResponse response) throws DialogInputParseException {
        return response.asToggle();
    }

    @Override
    public String asSubstitution(Boolean value) {
        return value != false ? this.onTrue : this.onFalse;
    }

    @Override
    public void addToMap(NbtMapBuilder builder, Boolean value) {
        builder.putBoolean(this.key, value);
    }

    @Override
    public Boolean defaultValue() {
        return this.initial;
    }
}

