/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.ParticleType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.viaproxy.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.registry.loader.EffectRegistryLoader;
import org.geysermc.geyser.registry.type.ParticleMapping;

public class ParticleTypesRegistryLoader
extends EffectRegistryLoader<Map<org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType, ParticleMapping>> {
    @Override
    public Map<org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType, ParticleMapping> load(String input) {
        JsonObject particlesJson = this.loadFile(input);
        Object2ObjectOpenHashMap<org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType, ParticleMapping> particles = new Object2ObjectOpenHashMap<org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType, ParticleMapping>();
        try {
            for (Map.Entry entry : particlesJson.entrySet()) {
                String key = ((String)entry.getKey()).toUpperCase(Locale.ROOT);
                JsonElement bedrockId = ((JsonElement)entry.getValue()).getAsJsonObject().get("bedrockId");
                JsonElement eventType = ((JsonElement)entry.getValue()).getAsJsonObject().get("eventType");
                if (eventType == null && bedrockId == null) {
                    GeyserImpl.getInstance().getLogger().debug("Skipping particle mapping " + key + " because no Bedrock equivalent exists.");
                    continue;
                }
                Enum type = null;
                if (eventType != null) {
                    try {
                        type = ParticleType.valueOf(eventType.getAsString().toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException ex) {
                        type = LevelEvent.valueOf(eventType.getAsString().toUpperCase(Locale.ROOT));
                    }
                }
                particles.put(org.geysermc.mcprotocollib.protocol.data.game.level.particle.ParticleType.valueOf(key), new ParticleMapping((LevelEventType)((Object)type), bedrockId == null ? null : bedrockId.getAsString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return particles;
    }
}

