/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakChildChannel;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.RakDisconnectReason;
import org.geysermc.geyser.platform.viaproxy.shaded.org.cloudburstmc.netty.channel.raknet.packet.EncapsulatedPacket;

public class RakChannelPipeline
extends DefaultChannelPipeline {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(RakChannelPipeline.class);
    private final RakChildChannel child;

    protected RakChannelPipeline(Channel parent, RakChildChannel child) {
        super(parent);
        this.child = child;
    }

    protected void onUnhandledInboundChannelActive() {
    }

    protected void onUnhandledInboundChannelInactive() {
        if (this.child.isActive()) {
            this.child.setActive(false);
            this.child.pipeline().fireChannelInactive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
        try {
            Object message = msg instanceof EncapsulatedPacket ? ((EncapsulatedPacket)((Object)msg)).toMessage() : msg;
            ReferenceCountUtil.retain((Object)message);
            if (this.child.eventLoop().inEventLoop()) {
                this.child.pipeline().fireChannelRead(message).fireChannelReadComplete();
            } else {
                this.child.eventLoop().execute(() -> this.child.pipeline().fireChannelRead(message).fireChannelReadComplete());
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    protected void onUnhandledInboundUserEventTriggered(Object evt) {
        this.child.pipeline().fireUserEventTriggered(evt);
        if (evt instanceof RakDisconnectReason) {
            this.child.close();
        }
    }

    protected void onUnhandledInboundException(Throwable cause) {
        log.error("Exception thrown in RakNet pipeline", cause);
    }
}

