/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy;

import io.netty.channel.AbstractChannel;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.lenni0451.lambdaevents.EventHandler;
import net.lenni0451.reflect.stream.RStream;
import net.raphimc.vialegacy.api.LegacyProtocolVersion;
import net.raphimc.viaproxy.ViaProxy;
import net.raphimc.viaproxy.plugins.PluginManager;
import net.raphimc.viaproxy.plugins.ViaProxyPlugin;
import net.raphimc.viaproxy.plugins.events.Client2ProxyChannelInitializeEvent;
import net.raphimc.viaproxy.plugins.events.ConsoleCommandEvent;
import net.raphimc.viaproxy.plugins.events.ProxyStartEvent;
import net.raphimc.viaproxy.plugins.events.ProxyStopEvent;
import net.raphimc.viaproxy.plugins.events.ShouldVerifyOnlineModeEvent;
import net.raphimc.viaproxy.plugins.events.ViaProxyLoadedEvent;
import net.raphimc.viaproxy.plugins.events.types.ITyped;
import net.raphimc.viaproxy.protocoltranslator.viaproxy.ViaProxyConfig;
import org.apache.logging.log4j.LogManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.api.event.EventRegistrar;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.command.standalone.StandaloneCloudCommandManager;
import org.geysermc.geyser.configuration.ConfigLoader;
import org.geysermc.geyser.configuration.GeyserConfig;
import org.geysermc.geyser.configuration.GeyserPluginConfig;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.viaproxy.GeyserViaProxyDumpInfo;
import org.geysermc.geyser.platform.viaproxy.GeyserViaProxyLogger;
import org.geysermc.geyser.platform.viaproxy.listener.GeyserServerTransferListener;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.LoopbackUtil;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class GeyserViaProxyPlugin
extends ViaProxyPlugin
implements GeyserBootstrap,
EventRegistrar {
    private static final File ROOT_FOLDER = new File(PluginManager.PLUGINS_DIR, "Geyser");
    private final GeyserViaProxyLogger logger = new GeyserViaProxyLogger(LogManager.getLogger((String)"Geyser"));
    private GeyserPluginConfig geyserConfig;
    private GeyserImpl geyser;
    private StandaloneCloudCommandManager cloud;
    private CommandRegistry commandRegistry;
    private IGeyserPingPassthrough pingPassthrough;

    public void onEnable() {
        ROOT_FOLDER.mkdirs();
        ViaProxy.EVENT_MANAGER.register((Object)this);
    }

    public void onDisable() {
        this.onGeyserShutdown();
    }

    @EventHandler
    private void onViaProxyLoaded(ViaProxyLoadedEvent event) {
        GeyserLocale.init(this);
        this.onGeyserInitialize();
    }

    @EventHandler
    private void onConsoleCommand(ConsoleCommandEvent event) {
        String command = event.getCommand().startsWith("/") ? event.getCommand().substring(1) : event.getCommand();
        CommandRegistry registry = this.getCommandRegistry();
        if (registry.rootCommands().contains(command)) {
            registry.runCommand(this.getGeyserLogger(), command + " " + String.join((CharSequence)" ", event.getArgs()));
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onShouldVerifyOnlineModeEvent(ShouldVerifyOnlineModeEvent event) {
        UUID uuid = event.getProxyConnection().getGameProfile().getId();
        if (uuid == null) {
            return;
        }
        GeyserSession connection = GeyserImpl.getInstance().onlineConnections().stream().filter(s -> s.javaUuid().equals(uuid)).findAny().orElse(null);
        if (connection == null) {
            return;
        }
        if (connection.javaUsername().equals(event.getProxyConnection().getGameProfile().getName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onClient2ProxyChannelInitialize(Client2ProxyChannelInitializeEvent event) {
        if (event.getType() != ITyped.Type.POST || event.isLegacyPassthrough()) {
            return;
        }
        if (System.getProperty("geyser.viaproxy.disableIpPassthrough") != null) {
            return;
        }
        GeyserSession session = GeyserImpl.getInstance().onlineConnections().stream().filter(c -> c.getDownstream() != null).filter(c -> c.getDownstream().getSession().getLocalAddress().equals(event.getChannel().remoteAddress())).findAny().orElse(null);
        if (session != null) {
            InetSocketAddress realAddress = session.getSocketAddress();
            if (event.getChannel() instanceof AbstractChannel) {
                RStream.of(AbstractChannel.class, (Object)event.getChannel()).fields().by("remoteAddress").set((Object)realAddress);
            }
        }
    }

    @EventHandler
    private void onProxyStart(ProxyStartEvent event) {
        this.onGeyserEnable();
    }

    @EventHandler
    private void onProxyStop(ProxyStopEvent event) {
        this.onGeyserDisable();
    }

    @Override
    public void onGeyserInitialize() {
        this.geyserConfig = this.loadConfig(GeyserPluginConfig.class);
        if (this.geyserConfig == null) {
            return;
        }
        this.geyser = GeyserImpl.load(this);
        this.geyser.eventBus().register(this, new GeyserServerTransferListener());
        LoopbackUtil.checkAndApplyLoopback(this.logger);
    }

    @Override
    public void onGeyserEnable() {
        if (this.geyser == null) {
            return;
        }
        boolean reloading = this.geyser.isReloading();
        if (reloading) {
            this.geyserConfig = this.loadConfig(GeyserPluginConfig.class);
            if (this.geyserConfig == null) {
                return;
            }
        } else {
            this.cloud = new StandaloneCloudCommandManager(this.geyser);
            this.commandRegistry = new CommandRegistry(this.geyser, this.cloud);
        }
        GeyserImpl.start();
        if (!reloading) {
            this.cloud.fireRegisterPermissionsEvent();
        }
        if (ViaProxy.getConfig().getTargetVersion() != null && ViaProxy.getConfig().getTargetVersion().newerThanOrEqualTo(LegacyProtocolVersion.b1_8tob1_8_1)) {
            this.pingPassthrough = GeyserLegacyPingPassthrough.init(this.geyser);
        }
        if (this.geyserConfig.java().authType() == AuthType.FLOODGATE) {
            ViaProxy.getConfig().setPassthroughBungeecordPlayerInfo(true);
        }
    }

    @Override
    public void onGeyserDisable() {
        this.geyser.disable();
    }

    @Override
    public void onGeyserShutdown() {
        this.geyser.shutdown();
    }

    @Override
    public @NonNull PlatformType platformType() {
        return PlatformType.VIAPROXY;
    }

    @Override
    public GeyserPluginConfig config() {
        return this.geyserConfig;
    }

    @Override
    public GeyserLogger getGeyserLogger() {
        return this.logger;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.pingPassthrough;
    }

    @Override
    public Path getConfigFolder() {
        return ROOT_FOLDER.toPath();
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserViaProxyDumpInfo();
    }

    @Override
    public @NonNull String getServerPlatform() {
        return PlatformType.VIAPROXY.platformName();
    }

    @Override
    public @NonNull String getServerBindAddress() {
        SocketAddress socketAddress = ViaProxy.getConfig().getBindAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress2 = (InetSocketAddress)socketAddress;
            return socketAddress2.getHostString();
        }
        throw new IllegalStateException("Unsupported bind address type: " + ViaProxy.getConfig().getBindAddress().getClass().getName());
    }

    @Override
    public int getServerPort() {
        SocketAddress socketAddress = ViaProxy.getConfig().getBindAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress2 = (InetSocketAddress)socketAddress;
            return socketAddress2.getPort();
        }
        throw new IllegalStateException("Unsupported bind address type: " + ViaProxy.getConfig().getBindAddress().getClass().getName());
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        return false;
    }

    @Override
    public Path getFloodgateKeyPath() {
        return new File(ROOT_FOLDER, this.geyserConfig.advanced().floodgateKeyFile()).toPath();
    }

    @Override
    public <T extends GeyserConfig> T loadConfig(Class<T> configClass) {
        T config = new ConfigLoader(this).transformer(node -> {
            try {
                CommentedConfigurationNode pingPassthroughInterval;
                int interval;
                if (!ViaProxy.getConfig().getWildcardDomainHandling().equals((Object)ViaProxyConfig.WildcardDomainHandling.NONE)) {
                    ((CommentedConfigurationNode)node.node(new Object[]{"java", "forward-host"})).set(true);
                }
                if ((interval = (pingPassthroughInterval = (CommentedConfigurationNode)node.node(new Object[]{"ping-passthrough-interval"})).getInt()) < 15 && ViaProxy.getConfig().getTargetVersion() != null && ViaProxy.getConfig().getTargetVersion().olderThanOrEqualTo(LegacyProtocolVersion.r1_6_4)) {
                    pingPassthroughInterval.set(15);
                }
            }
            catch (SerializationException e) {
                throw new RuntimeException(e);
            }
        }).configFile(new File(ROOT_FOLDER, "config.yml")).load(configClass);
        if (config != null) {
            this.geyserConfig = (GeyserPluginConfig)config;
            config.java().authType(Files.isRegularFile(this.getFloodgateKeyPath(), new LinkOption[0]) ? AuthType.FLOODGATE : AuthType.OFFLINE);
        }
        return config;
    }
}

