/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.viaproxy;

import net.raphimc.viaproxy.cli.ConsoleFormatter;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.GeyserCommandSource;

public class GeyserViaProxyLogger
implements GeyserLogger,
GeyserCommandSource {
    private final Logger logger;
    private boolean debug;

    public GeyserViaProxyLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void severe(String message) {
        this.logger.fatal(ConsoleFormatter.convert((String)message));
    }

    @Override
    public void severe(String message, Throwable error) {
        this.logger.fatal(ConsoleFormatter.convert((String)message), error);
    }

    @Override
    public void error(String message) {
        this.logger.error(ConsoleFormatter.convert((String)message));
    }

    @Override
    public void error(String message, Throwable error) {
        this.logger.error(ConsoleFormatter.convert((String)message), error);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(ConsoleFormatter.convert((String)message));
    }

    @Override
    public void info(String message) {
        this.logger.info(ConsoleFormatter.convert((String)message));
    }

    @Override
    public void debug(String message) {
        if (this.debug) {
            this.logger.debug(ConsoleFormatter.convert((String)message));
        }
    }

    @Override
    public void debug(@Nullable Object object) {
        if (this.debug) {
            this.logger.debug(ConsoleFormatter.convert((String)String.valueOf(object)));
        }
    }

    @Override
    public void debug(String message, Object ... arguments) {
        if (this.debug) {
            this.debug(String.format(message, arguments));
        }
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }
}

