/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack;

import java.util.Objects;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.pack.PackCodec;
import org.geysermc.geyser.api.pack.ResourcePack;
import org.geysermc.geyser.api.pack.ResourcePackManifest;

public record GeyserResourcePack(@NonNull PackCodec codec, @NonNull ResourcePackManifest manifest, @NonNull String contentKey) implements ResourcePack
{
    public static final int CHUNK_SIZE = 262144;

    @Generated
    public GeyserResourcePack withCodec(@NonNull PackCodec codec) {
        if (codec == null) {
            throw new NullPointerException("codec is marked non-null but is null");
        }
        return this.codec == codec ? this : new GeyserResourcePack(codec, this.manifest, this.contentKey);
    }

    @Generated
    public GeyserResourcePack withManifest(@NonNull ResourcePackManifest manifest) {
        if (manifest == null) {
            throw new NullPointerException("manifest is marked non-null but is null");
        }
        return this.manifest == manifest ? this : new GeyserResourcePack(this.codec, manifest, this.contentKey);
    }

    @Generated
    public GeyserResourcePack withContentKey(@NonNull String contentKey) {
        if (contentKey == null) {
            throw new NullPointerException("contentKey is marked non-null but is null");
        }
        return this.contentKey == contentKey ? this : new GeyserResourcePack(this.codec, this.manifest, contentKey);
    }

    public static class Builder
    implements ResourcePack.Builder {
        private final PackCodec codec;
        private final ResourcePackManifest manifest;
        private String contentKey = "";

        public Builder(PackCodec codec, ResourcePackManifest manifest) {
            this.codec = codec;
            this.manifest = manifest;
        }

        public Builder(PackCodec codec, ResourcePackManifest manifest, String contentKey) {
            this.codec = codec;
            this.manifest = manifest;
            this.contentKey = contentKey;
        }

        @Override
        public ResourcePackManifest manifest() {
            return this.manifest;
        }

        @Override
        public PackCodec codec() {
            return this.codec;
        }

        @Override
        public String contentKey() {
            return this.contentKey;
        }

        @Override
        public Builder contentKey(@NonNull String contentKey) {
            Objects.requireNonNull(contentKey);
            this.contentKey = contentKey;
            return this;
        }

        @Override
        public GeyserResourcePack build() {
            return new GeyserResourcePack(this.codec, this.manifest, this.contentKey);
        }
    }
}

