/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl;

import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.v2.component.java.KineticWeapon;

public record KineticWeaponImpl(@NonNegative int delayTicks, @Nullable KineticWeapon.Condition dismountConditions) implements KineticWeapon
{

    public record ConditionImpl(@NonNegative int maxDurationTicks, float minSpeed, float minRelativeSpeed) implements KineticWeapon.Condition
    {

        public static class Builder
        implements KineticWeapon.Condition.Builder {
            private final int maxDurationTicks;
            private float minSpeed = 0.0f;
            private float minRelativeSpeed = 0.0f;

            public Builder(int maxDurationTicks) {
                if (maxDurationTicks < 0) {
                    throw new IllegalArgumentException("max duration ticks must not be negative");
                }
                this.maxDurationTicks = maxDurationTicks;
            }

            @Override
            public Builder minSpeed(float minSpeed) {
                this.minSpeed = minSpeed;
                return this;
            }

            @Override
            public Builder minRelativeSpeed(float minRelativeSpeed) {
                this.minRelativeSpeed = minRelativeSpeed;
                return this;
            }

            @Override
            public KineticWeapon.Condition build() {
                return new ConditionImpl(this.maxDurationTicks, this.minSpeed, this.minRelativeSpeed);
            }
        }
    }

    public static class Builder
    implements KineticWeapon.Builder {
        private int delayTicks = 0;
        private KineticWeapon.Condition dismountConditions = null;

        @Override
        public Builder delayTicks(int delayTicks) {
            if (delayTicks < 0) {
                throw new IllegalArgumentException("delay ticks must not be negative");
            }
            this.delayTicks = delayTicks;
            return this;
        }

        @Override
        public Builder dismountConditions(@Nullable KineticWeapon.Condition dismountConditions) {
            this.dismountConditions = dismountConditions;
            return this;
        }

        @Override
        public KineticWeapon build() {
            return new KineticWeaponImpl(this.delayTicks, this.dismountConditions);
        }
    }
}

