/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom.impl;

import java.util.Objects;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.component.java.Consumable;

public record ConsumableImpl(float consumeSeconds, @NonNull Consumable.Animation animation) implements Consumable
{

    public static class Builder
    implements Consumable.Builder {
        private float consumeSeconds = 1.6f;
        private Consumable.Animation animation = Consumable.Animation.EAT;

        @Override
        public Builder consumeSeconds(@Positive float consumeSeconds) {
            if (consumeSeconds <= 0.0f) {
                throw new IllegalArgumentException("consume seconds must be above 0");
            }
            this.consumeSeconds = consumeSeconds;
            return this;
        }

        @Override
        public Builder animation(@NonNull Consumable.Animation animation) {
            Objects.requireNonNull(animation, "animation cannot be null");
            this.animation = animation;
            return this;
        }

        @Override
        public Consumable build() {
            return new ConsumableImpl(this.consumeSeconds, this.animation);
        }
    }
}

