/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.configuration;

import java.util.List;
import java.util.UUID;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.configuration.ExcludePlatform;
import org.geysermc.geyser.configuration.GeyserConfig;
import org.geysermc.geyser.configuration.PluginSpecific;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.geyser.util.CooldownUtils;
import org.spongepowered.configurate.interfaces.meta.defaults.DefaultBoolean;
import org.spongepowered.configurate.interfaces.meta.defaults.DefaultNumeric;
import org.spongepowered.configurate.interfaces.meta.defaults.DefaultString;
import org.spongepowered.configurate.interfaces.meta.range.NumericRange;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
final class GeyserConfigImpl
implements GeyserConfig {
    @Comment(value="Network settings for the Bedrock listener")
    private GeyserConfig.BedrockConfig bedrock = new BedrockConfigImpl();
    @Comment(value="Network settings for the Java server connection")
    private GeyserConfig.JavaConfig java = new JavaConfigImpl();
    @Comment(value="MOTD settings")
    private GeyserConfig.MotdConfig motd = new MotdConfigImpl();
    @Comment(value="Gameplay options that affect Bedrock players")
    private GeyserConfig.GameplayConfig gameplay = new GameplayConfigImpl();
    @DefaultString(value="system")
    @Comment(value="The default locale if we don't have the one the client requested. If set to \"system\", the system's language will be used.")
    private String defaultLocale = "system";
    @DefaultBoolean(value=true)
    @Comment(value="Whether player IP addresses will be logged by the server.")
    private boolean logPlayerIpAddresses = true;
    @Comment(value="For online mode authentication type only.\nStores a list of Bedrock player usernames that should have their Java Edition account saved after login.\nThis saves a token that can be reused to authenticate the player later. This does not save emails or passwords,\nbut you should still be cautious when adding to this list and giving others access to this Geyser instance's files.\nRemoving a name from this list will delete its cached login information on the next Geyser startup.\nThe file that tokens will be saved in is in the same folder as this config, named \"saved-refresh-tokens.json\".")
    private List<String> savedUserLogins = GeyserConfig.super.savedUserLogins();
    @DefaultNumeric(value=120L)
    @Comment(value="For online mode authentication type only.\nSpecify how many seconds to wait while user authorizes Geyser to access their Microsoft account.\nUser is allowed to disconnect from the server during this period.")
    private int pendingAuthenticationTimeout = 120;
    @DefaultBoolean(value=true)
    @Comment(value="Whether to alert the console and operators that a new Geyser version is available that supports a Bedrock version\nthat this Geyser version does not support. It's recommended to keep this option enabled, as many Bedrock platforms\nauto-update.")
    private boolean notifyOnNewBedrockUpdate = true;
    @Comment(value="Advanced configuration options. These usually do not need modifications.")
    private GeyserConfig.AdvancedConfig advanced = new AdvancedConfigImpl();
    @DefaultBoolean(value=true)
    @Comment(value="bStats is a stat tracker that is entirely anonymous and tracks only basic information\nabout Geyser, such as how many people are online, how many servers are using Geyser,\nwhat OS is being used, etc. You can learn more about bStats here: https://bstats.org/.\nhttps://bstats.org/plugin/server-implementation/GeyserMC")
    @ExcludePlatform(platforms={"BungeeCord", "Spigot", "Velocity"})
    private boolean enableMetrics = true;
    @Comment(value="The bstats metrics uuid. Do not touch!")
    @ExcludePlatform(platforms={"BungeeCord", "Spigot", "Velocity"})
    private UUID metricsUuid = GeyserConfig.super.metricsUuid();
    @Comment(value="If debug messages should be sent through console")
    private boolean debugMode;
    @Comment(value="Do not change!")
    private int configVersion = GeyserConfig.super.configVersion();

    GeyserConfigImpl() {
    }

    @Override
    public GeyserConfig.BedrockConfig bedrock() {
        return this.bedrock;
    }

    @Override
    public GeyserConfig.JavaConfig java() {
        return this.java;
    }

    @Override
    public GeyserConfig.MotdConfig motd() {
        return this.motd;
    }

    @Override
    public GeyserConfig.GameplayConfig gameplay() {
        return this.gameplay;
    }

    @Override
    public String defaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public boolean logPlayerIpAddresses() {
        return this.logPlayerIpAddresses;
    }

    @Override
    public List<String> savedUserLogins() {
        return this.savedUserLogins;
    }

    @Override
    public int pendingAuthenticationTimeout() {
        return this.pendingAuthenticationTimeout;
    }

    @Override
    public boolean notifyOnNewBedrockUpdate() {
        return this.notifyOnNewBedrockUpdate;
    }

    @Override
    public GeyserConfig.AdvancedConfig advanced() {
        return this.advanced;
    }

    @Override
    public boolean enableMetrics() {
        return this.enableMetrics;
    }

    @Override
    public UUID metricsUuid() {
        return this.metricsUuid;
    }

    @Override
    public boolean debugMode() {
        return this.debugMode;
    }

    @Override
    public int configVersion() {
        return this.configVersion;
    }

    @ConfigSerializable
    static final class BedrockConfigImpl
    implements GeyserConfig.BedrockConfig {
        @DefaultString(value="0.0.0.0")
        @Comment(value="The IP address that Geyser will bind on to listen for incoming Bedrock connections.\nGenerally, you should only change this if you want to limit what IPs can connect to your server.")
        @AsteriskSerializer.Asterisk
        private String address = "0.0.0.0";
        @DefaultNumeric(value=19132L)
        @Comment(value="The port that will Geyser will listen on for incoming Bedrock connections.\nSince Minecraft: Bedrock Edition uses UDP, this port must allow UDP traffic.")
        @NumericRange(from=0L, to=65535L)
        private int port = 19132;
        @DefaultBoolean(value=false)
        @Comment(value="Some hosting services change your Java port everytime you start the server and require the same port to be used for Bedrock.\nThis option makes the Bedrock port the same as the Java port every time you start the server.")
        @PluginSpecific
        private boolean cloneRemotePort = false;

        BedrockConfigImpl() {
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public boolean cloneRemotePort() {
            return this.cloneRemotePort;
        }

        @Override
        public void address(String address) {
            this.address = address;
        }

        @Override
        public void port(int port) {
            this.port = port;
        }
    }

    @ConfigSerializable
    static final class JavaConfigImpl
    implements GeyserConfig.JavaConfig {
        private String address;
        private int port;
        @Comment(value="What type of authentication Bedrock players will be checked against when logging into the Java server.\nCan be \"floodgate\" (see https://wiki.geysermc.org/floodgate/), \"online\", or \"offline\".")
        private AuthType authType = GeyserConfig.JavaConfig.super.authType();
        private boolean forwardHostname;

        JavaConfigImpl() {
        }

        @Override
        public void address(String address) {
            this.address = address;
        }

        @Override
        public void port(int port) {
            this.port = port;
        }

        @Override
        public AuthType authType() {
            return this.authType;
        }

        @Override
        public void authType(AuthType authType) {
            this.authType = authType;
        }

        @Override
        public boolean forwardHostname() {
            return this.forwardHostname;
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public int port() {
            return this.port;
        }
    }

    @ConfigSerializable
    static final class MotdConfigImpl
    implements GeyserConfig.MotdConfig {
        @DefaultString(value="Geyser")
        @Comment(value="The MOTD that will be broadcasted to Minecraft: Bedrock Edition clients. This is irrelevant if \"passthrough-motd\" is set to true.\nIf either of these are empty, the respective string will default to \"Geyser\"")
        private String primaryMotd = "Geyser";
        @DefaultString(value="Another Geyser server.")
        private String secondaryMotd = "Another Geyser server.";
        @DefaultBoolean(value=true)
        @Comment(value="Whether Geyser should relay the MOTD from the Java server to Bedrock players.")
        private boolean passthroughMotd = true;
        @DefaultNumeric(value=100L)
        @Comment(value="Maximum amount of players that can connect.\nThis is only visual, and is only applied if passthrough-motd is disabled.")
        private int maxPlayers = 100;
        @DefaultBoolean(value=true)
        @Comment(value="Whether to relay the player count and max players from the Java server to Bedrock players.")
        private boolean passthroughPlayerCounts = true;
        @DefaultBoolean(value=true)
        @Comment(value="Whether to use server API methods to determine the Java server's MOTD and ping passthrough.\nThere is no need to disable this unless your MOTD or player count does not appear properly.")
        @PluginSpecific
        private boolean integratedPingPassthrough = true;
        @DefaultNumeric(value=3L)
        @Comment(value="How often to ping the Java server to refresh MOTD and player count, in seconds.")
        private int pingPassthroughInterval = 3;

        MotdConfigImpl() {
        }

        @Override
        public String primaryMotd() {
            return this.primaryMotd;
        }

        @Override
        public String secondaryMotd() {
            return this.secondaryMotd;
        }

        @Override
        public boolean passthroughMotd() {
            return this.passthroughMotd;
        }

        @Override
        public int maxPlayers() {
            return this.maxPlayers;
        }

        @Override
        public boolean passthroughPlayerCounts() {
            return this.passthroughPlayerCounts;
        }

        @Override
        public boolean integratedPingPassthrough() {
            return this.integratedPingPassthrough;
        }

        @Override
        public int pingPassthroughInterval() {
            return this.pingPassthroughInterval;
        }
    }

    @ConfigSerializable
    static final class GameplayConfigImpl
    implements GeyserConfig.GameplayConfig {
        @DefaultString(value="Geyser")
        @Comment(value="The server name that will be sent to Minecraft: Bedrock Edition clients. This is visible in both the pause menu and the settings menu.")
        private String serverName = "Geyser";
        @Comment(value="Allow a fake cooldown indicator to be sent. Bedrock players otherwise do not see a cooldown as they still use 1.8 combat.\nPlease note: if the cooldown is enabled, some users may see a black box during the cooldown sequence, like below:\nhttps://geysermc.org/img/external/cooldown_indicator.png\nThis can be disabled by going into Bedrock settings under the accessibility tab and setting \"Text Background Opacity\" to 0\nThis setting can be set to \"title\", \"actionbar\" or \"disabled\"")
        private CooldownUtils.CooldownType showCooldown = GeyserConfig.GameplayConfig.super.showCooldown();
        @DefaultBoolean(value=true)
        @Comment(value="Bedrock clients can freeze when opening up the command prompt for the first time if given a lot of commands.\nDisabling this will prevent command suggestions from being sent and solve freezing for Bedrock clients.")
        private boolean commandSuggestions = true;
        @DefaultBoolean(value=true)
        @Comment(value="Controls if coordinates are shown to players.")
        private boolean showCoordinates = true;
        @Comment(value="Whether Bedrock players are blocked from performing their scaffolding-style bridging.")
        private boolean disableBedrockScaffolding;
        @Comment(value="Bedrock prevents building and displaying blocks above Y127 in the Nether.\nThis config option works around that by changing the Nether dimension ID to the End ID.\nThe main downside to this is that the entire Nether will have the same red fog rather than having different fog for each biome.")
        private boolean netherRoofWorkaround;
        @DefaultBoolean(value=true)
        @Comment(value="Whether to show Bedrock Edition emotes to other Bedrock Edition players.\n")
        private boolean emotesEnabled = true;
        @DefaultString(value="minecraft:barrier")
        @Comment(value="Which item to use to mark unavailable slots in a Bedrock player inventory. Examples of this are the 2x2 crafting grid while in creative,\nor custom inventory menus with sizes different from the usual 3x9. A barrier block is the default item.\nThis config option can be set to any Bedrock item identifier. If you want to set this to a custom item, make sure that you specify the item in the following format: \"geyser_custom:<mapping-name>\"\n")
        private String unusableSpaceBlock = "minecraft:barrier";
        @DefaultBoolean(value=true)
        @Comment(value="Whether to add any items and blocks which normally does not exist in Bedrock Edition.\nThis should only need to be disabled if using a proxy that does not use the \"transfer packet\" style of server switching.\nIf this is disabled, furnace minecart items will be mapped to hopper minecart items.\nGeyser's block, item, and skull mappings systems will also be disabled.\nThis option requires a restart of Geyser in order to change its setting.")
        private boolean enableCustomContent = true;
        @DefaultBoolean(value=true)
        @Comment(value="Force clients to load all resource packs if there are any.\nIf set to false, it allows the user to connect to the server even if they don't\nwant to download the resource packs.")
        private boolean forceResourcePacks = true;
        @DefaultBoolean(value=true)
        @Comment(value="Whether to automatically serve a resource pack that is required for some Geyser features to all connecting Bedrock players.\nIf enabled, force-resource-packs will be enabled.")
        private boolean enableIntegratedPack = true;
        @Comment(value="Whether to forward player ping to the server. While enabling this will allow Bedrock players to have more accurate\nping, it may also cause players to time out more easily.")
        private boolean forwardPlayerPing;
        @Comment(value="Allows Xbox achievements to be unlocked.\nIf a player types in an unknown command, they will receive a message that states cheats are disabled.\nOtherwise, commands work as expected.")
        private boolean xboxAchievementsEnabled;
        @DefaultNumeric(value=128L)
        @Comment(value="The maximum number of custom skulls to be displayed per player. Increasing this may decrease performance on weaker devices.\nA value of 0 will disable all custom skulls.\nSetting this to -1 will cause all custom skulls to be displayed regardless of distance or number.")
        private int maxVisibleCustomSkulls = 128;
        @DefaultNumeric(value=32L)
        @Comment(value="The radius in blocks around the player in which custom skulls are displayed.")
        private int customSkullRenderDistance = 32;

        GameplayConfigImpl() {
        }

        @Override
        public String serverName() {
            return this.serverName;
        }

        @Override
        public CooldownUtils.CooldownType showCooldown() {
            return this.showCooldown;
        }

        @Override
        public boolean commandSuggestions() {
            return this.commandSuggestions;
        }

        @Override
        public boolean showCoordinates() {
            return this.showCoordinates;
        }

        @Override
        public boolean disableBedrockScaffolding() {
            return this.disableBedrockScaffolding;
        }

        @Override
        public boolean netherRoofWorkaround() {
            return this.netherRoofWorkaround;
        }

        @Override
        public boolean emotesEnabled() {
            return this.emotesEnabled;
        }

        @Override
        public String unusableSpaceBlock() {
            return this.unusableSpaceBlock;
        }

        @Override
        public boolean enableCustomContent() {
            return this.enableCustomContent;
        }

        @Override
        public boolean forceResourcePacks() {
            return this.forceResourcePacks;
        }

        @Override
        public boolean enableIntegratedPack() {
            return this.enableIntegratedPack;
        }

        @Override
        public boolean forwardPlayerPing() {
            return this.forwardPlayerPing;
        }

        @Override
        public boolean xboxAchievementsEnabled() {
            return this.xboxAchievementsEnabled;
        }

        @Override
        public int maxVisibleCustomSkulls() {
            return this.maxVisibleCustomSkulls;
        }

        @Override
        public int customSkullRenderDistance() {
            return this.customSkullRenderDistance;
        }
    }

    @ConfigSerializable
    static final class AdvancedConfigImpl
    implements GeyserConfig.AdvancedConfig {
        @Comment(value="Specify how many days player skin images will be cached to disk to save downloading them from the internet.\nA value of 0 is disabled. (Default: 0)")
        private int cacheImages;
        @DefaultNumeric(value=20L)
        @Comment(value="Geyser updates the Scoreboard after every Scoreboard packet, but when Geyser tries to handle\na lot of scoreboard packets per second, this can cause serious lag.\nThis option allows you to specify after how many Scoreboard packets per seconds\nthe Scoreboard updates will be limited to four updates per second.")
        private int scoreboardPacketThreshold = 20;
        @DefaultBoolean(value=true)
        @Comment(value="Whether Geyser should send team names in command suggestions.\nDisable this if you have a lot of teams used that you don't need as suggestions.")
        private boolean addTeamSuggestions = true;
        @Comment(value="A list of remote resource pack urls to send to the Bedrock client for downloading.\nThe Bedrock client is very picky about how these are delivered - please see our wiki page for further info: https://geysermc.org/wiki/geyser/packs/\n")
        private List<String> resourcePackUrls = GeyserConfig.AdvancedConfig.super.resourcePackUrls();
        @DefaultString(value="key.pem")
        @Comment(value="Floodgate uses encryption to ensure use from authorized sources.\nThis should point to the public key generated by Floodgate (BungeeCord, Spigot or Velocity)\nYou can ignore this when not using Floodgate.\nIf you're using a plugin version of Floodgate on the same server, the key will automatically be picked up from Floodgate.")
        private String floodgateKeyFile = "key.pem";
        @Comment(value="Advanced networking options for the Geyser to Java server connection")
        private GeyserConfig.AdvancedJavaConfig java = new AdvancedJavaConfigImpl();
        @Comment(value="Advanced networking options for Geyser's Bedrock listener")
        private GeyserConfig.AdvancedBedrockConfig bedrock = new AdvancedBedrockConfigImpl();

        AdvancedConfigImpl() {
        }

        @Override
        public int cacheImages() {
            return this.cacheImages;
        }

        @Override
        public int scoreboardPacketThreshold() {
            return this.scoreboardPacketThreshold;
        }

        @Override
        public boolean addTeamSuggestions() {
            return this.addTeamSuggestions;
        }

        @Override
        public List<String> resourcePackUrls() {
            return this.resourcePackUrls;
        }

        @Override
        public String floodgateKeyFile() {
            return this.floodgateKeyFile;
        }

        @Override
        public GeyserConfig.AdvancedJavaConfig java() {
            return this.java;
        }

        @Override
        public GeyserConfig.AdvancedBedrockConfig bedrock() {
            return this.bedrock;
        }
    }

    @ConfigSerializable
    static final class AdvancedJavaConfigImpl
    implements GeyserConfig.AdvancedJavaConfig {
        @Comment(value="Whether to enable HAPROXY protocol when connecting to the Java server.\nThis is useful only when:\n1) Your Java server supports HAPROXY protocol (it probably doesn't)\n2) You run Velocity or BungeeCord with the option enabled in the proxy's main config.\nIF YOU DON'T KNOW WHAT THIS IS, DON'T TOUCH IT!")
        private boolean useHaproxyProtocol;
        @DefaultBoolean(value=true)
        @Comment(value="Whether to connect directly into the Java server without creating a TCP connection.\nThis should only be disabled if a plugin that interfaces with packets or the network does not work correctly with Geyser.\nIf enabled, the remote address and port sections are ignored.\nIf disabled, expect performance decrease and latency increase.\n")
        @PluginSpecific
        private boolean useDirectConnection = true;
        @DefaultBoolean(value=true)
        @Comment(value="Whether Geyser should attempt to disable packet compression (from the Java Server to Geyser) for Bedrock players.\nThis should be a benefit as there is no need to compress data when Java packets aren't being handled over the network.\nThis requires use-direct-connection to be true.\n")
        @PluginSpecific
        private boolean disableCompression = true;

        AdvancedJavaConfigImpl() {
        }

        @Override
        public boolean useHaproxyProtocol() {
            return this.useHaproxyProtocol;
        }

        @Override
        public boolean useDirectConnection() {
            return this.useDirectConnection;
        }

        @Override
        public boolean disableCompression() {
            return this.disableCompression;
        }
    }

    @ConfigSerializable
    static final class AdvancedBedrockConfigImpl
    implements GeyserConfig.AdvancedBedrockConfig {
        @DefaultNumeric(value=0L)
        @Comment(value="The port to broadcast to Bedrock clients with the MOTD that they should use to connect to the server.\nA value of 0 will broadcast the port specified above.\nDO NOT change this unless Geyser runs on a different port than the one that is used to connect.")
        @NumericRange(from=0L, to=65535L)
        private int broadcastPort = 0;
        @DefaultNumeric(value=6L)
        @Comment(value="How much to compress network traffic to the Bedrock client. The higher the number, the more CPU usage used, but\nthe smaller the bandwidth used. Does not have any effect below -1 or above 9. Set to -1 to disable.")
        @NumericRange(from=-1L, to=9L)
        private int compressionLevel = 6;
        @DefaultBoolean(value=false)
        @Comment(value="Whether to expect HAPROXY protocol for connecting Bedrock clients.\nThis is useful only when you are running a UDP reverse proxy in front of your Geyser instance.\nIF YOU DON'T KNOW WHAT THIS IS, DON'T TOUCH IT!")
        private boolean useHaproxyProtocol = false;
        @Comment(value="A list of allowed HAPROXY protocol speaking proxy IP addresses/subnets. Only effective when \"use-proxy-protocol\" is enabled, and\nshould really only be used when you are not able to use a proper firewall (usually true with shared hosting providers etc.).\nKeeping this list empty means there is no IP address whitelist.\nIP addresses, subnets, and links to plain text files are supported.")
        private List<String> haproxyProtocolWhitelistedIps = GeyserConfig.AdvancedBedrockConfig.super.haproxyProtocolWhitelistedIps();
        @DefaultNumeric(value=1400L)
        @Comment(value="The internet supports a maximum MTU of 1492 but could cause issues with packet fragmentation.\n1400 is the default.")
        private int mtu = 1400;
        @DefaultBoolean(value=true)
        @Comment(value="This option disables the auth step Geyser performs for connecting Bedrock players.\nIt can be used to allow connections from ProxyPass and WaterdogPE. In these cases, make sure that users\ncannot directly connect to this Geyser instance. See https://www.spigotmc.org/wiki/firewall-guide/ for\nassistance - and use UDP instead of TCP.\nDisabling Bedrock authentication for other use-cases is NOT SUPPORTED, as it allows anyone to spoof usernames, and is therefore a security risk.\nAll Floodgate functionality (including skin uploading and account linking) will also not work when this option is disabled.")
        private boolean validateBedrockLogin = true;

        AdvancedBedrockConfigImpl() {
        }

        @Override
        public int broadcastPort() {
            return this.broadcastPort;
        }

        @Override
        public void broadcastPort(int port) {
            this.broadcastPort = port;
        }

        @Override
        public int compressionLevel() {
            return this.compressionLevel;
        }

        @Override
        public boolean useHaproxyProtocol() {
            return this.useHaproxyProtocol;
        }

        @Override
        public List<String> haproxyProtocolWhitelistedIps() {
            return this.haproxyProtocolWhitelistedIps;
        }

        @Override
        public int mtu() {
            return this.mtu;
        }

        @Override
        public boolean validateBedrockLogin() {
            return this.validateBedrockLogin;
        }
    }
}

