/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.dump.DumpInfo;
import org.geysermc.geyser.platform.viaproxy.shaded.org.incendo.cloud.CommandManager;
import org.geysermc.geyser.platform.viaproxy.shaded.org.incendo.cloud.context.CommandContext;
import org.geysermc.geyser.platform.viaproxy.shaded.org.incendo.cloud.parser.standard.StringArrayParser;
import org.geysermc.geyser.platform.viaproxy.shaded.org.incendo.cloud.suggestion.SuggestionProvider;
import org.geysermc.geyser.text.AsteriskSerializer;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.JsonUtils;
import org.geysermc.geyser.util.WebUtils;

public class DumpCommand
extends GeyserCommand {
    private static final String ARGUMENTS = "args";
    private static final Iterable<String> SUGGESTIONS = List.of("full", "offline", "logs");
    private final GeyserImpl geyser;
    private static final String DUMP_URL = "https://dump.geysermc.org/";

    public DumpCommand(GeyserImpl geyser, String name, String description, String permission) {
        super(name, description, permission, TriState.NOT_SET);
        this.geyser = geyser;
    }

    @Override
    public void register(CommandManager<GeyserCommandSource> manager) {
        manager.command(this.baseBuilder(manager).optional(ARGUMENTS, StringArrayParser.stringArrayParser(), SuggestionProvider.blockingStrings((ctx, input) -> {
            List<String> inputs = new ArrayList<String>();
            while (input.hasRemainingInput()) {
                inputs.add(input.readStringSkipWhitespace());
            }
            if (inputs.size() <= 2) {
                return SUGGESTIONS;
            }
            inputs = inputs.subList(2, inputs.size());
            ArrayList suggestions = new ArrayList();
            SUGGESTIONS.forEach(suggestions::add);
            suggestions.removeAll(inputs);
            return suggestions;
        })).handler(this::execute));
    }

    @Override
    public void execute(CommandContext<GeyserCommandSource> context) {
        Object uploadedDumpUrl;
        String dumpData;
        GeyserCommandSource source = context.sender();
        String[] args = context.getOrDefault(ARGUMENTS, new String[0]);
        boolean showSensitive = false;
        boolean offlineDump = false;
        boolean addLog = false;
        if (args.length >= 1) {
            String[] stringArray = args;
            int n = stringArray.length;
            block16: for (int i = 0; i < n; ++i) {
                String arg;
                switch (arg = stringArray[i]) {
                    case "full": {
                        showSensitive = true;
                        continue block16;
                    }
                    case "offline": {
                        offlineDump = true;
                        continue block16;
                    }
                    case "logs": {
                        addLog = true;
                        continue block16;
                    }
                    default: {
                        context.sender().sendMessage("Invalid geyser dump option " + arg + "! Fallback to no arguments.");
                    }
                }
            }
        }
        AsteriskSerializer.showSensitive = showSensitive;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.dump.collecting", source.locale()));
        try {
            DumpInfo dump = new DumpInfo(this.geyser, addLog);
            dumpData = gson.toJson((Object)dump);
        }
        catch (Exception e) {
            source.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.dump.collect_error", source.locale()));
            this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.dump.collect_error_short"), e);
            return;
        }
        if (offlineDump) {
            source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.dump.writing", source.locale()));
            try {
                FileOutputStream outputStream = new FileOutputStream(GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("dump.json").toFile());
                outputStream.write(dumpData.getBytes());
                outputStream.close();
            }
            catch (IOException e) {
                source.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.dump.write_error", source.locale()));
                this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.dump.write_error_short"), e);
                return;
            }
            uploadedDumpUrl = "dump.json";
        } else {
            JsonObject responseNode;
            source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.dump.uploading", source.locale()));
            String response = null;
            try {
                response = WebUtils.post("https://dump.geysermc.org/documents", dumpData);
                responseNode = JsonUtils.parseJson(response);
            }
            catch (Throwable e) {
                source.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.dump.upload_error", source.locale()));
                this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.commands.dump.upload_error_short"), e);
                if (e instanceof JsonParseException && response != null) {
                    this.geyser.getLogger().error("Failed to parse dump response! got: " + response);
                }
                return;
            }
            if (!responseNode.has("key")) {
                source.sendMessage("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.commands.dump.upload_error_short", source.locale()) + ": " + (responseNode.has("message") ? responseNode.get("message").getAsString() : response));
                return;
            }
            uploadedDumpUrl = DUMP_URL + responseNode.get("key").getAsString();
        }
        source.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.commands.dump.message", source.locale()) + " \u00a73" + (String)uploadedDumpUrl);
        if (!source.isConsole()) {
            this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.commands.dump.created", source.name(), uploadedDumpUrl));
        }
    }
}

