/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.predicate.item;

import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.predicate.item.CustomModelDataPredicate;
import org.geysermc.geyser.api.predicate.item.HasComponentPredicate;
import org.geysermc.geyser.api.util.Identifier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface ItemConditionPredicate {
    public static final MinecraftPredicate<ItemPredicateContext> UNBREAKABLE = ItemPredicateContext::unbreakable;
    public static final MinecraftPredicate<ItemPredicateContext> DAMAGEABLE = context -> !context.unbreakable() && context.maxDamage() > 0;
    public static final MinecraftPredicate<ItemPredicateContext> BROKEN = DAMAGEABLE.and(context -> context.damage() >= context.maxDamage() - 1);
    public static final MinecraftPredicate<ItemPredicateContext> DAMAGED = DAMAGEABLE.and(context -> context.damage() >= 0);
    public static final MinecraftPredicate<ItemPredicateContext> FISHING_ROD_CAST = ItemPredicateContext::hasFishingRodCast;

    public static MinecraftPredicate<ItemPredicateContext> customModelData(@NonNegative int index) {
        return (MinecraftPredicate)GeyserApi.api().provider(CustomModelDataPredicate.FlagPredicate.class, index);
    }

    public static MinecraftPredicate<ItemPredicateContext> hasComponent(@NonNull Identifier component) {
        return (MinecraftPredicate)GeyserApi.api().provider(HasComponentPredicate.class, component);
    }
}

