/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.packet.geyserbound;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.erosion.packet.ProtocolUtils;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPacketHandler;

public final class GeyserboundBlockPlacePacket
implements GeyserboundPacket {
    private final Vector3i pos;
    private final int blockId;

    public GeyserboundBlockPlacePacket(Vector3i pos, int blockId) {
        this.pos = pos;
        this.blockId = blockId;
    }

    public GeyserboundBlockPlacePacket(ByteBuf buf) {
        this.pos = ProtocolUtils.readBlockPos(buf);
        this.blockId = VarInts.readUnsignedInt(buf);
    }

    @Override
    public void serialize(ByteBuf buf) {
        ProtocolUtils.writeBlockPos(buf, this.pos);
        VarInts.writeUnsignedInt(buf, this.blockId);
    }

    @Override
    public void handle(GeyserboundPacketHandler packetHandler) {
        packetHandler.handleBlockPlace(this);
    }

    public Vector3i getPos() {
        return this.pos;
    }

    public int getBlockId() {
        return this.blockId;
    }
}

