/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.command;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cloudburstmc.protocol.bedrock.data.command.ChainedSubCommandData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandOverloadData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParamData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;

public final class CommandData {
    private final String name;
    private final String description;
    private final Set<Flag> flags;
    private final CommandPermission permission;
    private final CommandEnumData aliases;
    private final List<ChainedSubCommandData> subcommands;
    private final CommandOverloadData[] overloads;

    public String toString() {
        StringBuilder overloads = new StringBuilder("[\r\n");
        for (CommandOverloadData overload : this.overloads) {
            overloads.append("    [\r\n");
            overloads.append("       chaining=").append(overload.isChaining()).append("\r\n");
            for (CommandParamData parameter : overload.getOverloads()) {
                overloads.append("       ").append(parameter).append("\r\n");
            }
            overloads.append("    ]\r\n");
        }
        overloads.append("]\r\n");
        StringBuilder builder = new StringBuilder("CommandData(\r\n");
        List<String> objects = Arrays.asList("name=" + this.name, "description=" + this.description, "flags=" + Arrays.toString(this.flags.toArray()), "permission=" + (Object)((Object)this.permission), "aliases=" + this.aliases, "subcommands=" + Arrays.toString(this.subcommands.toArray()), "overloads=" + overloads);
        for (String object : objects) {
            builder.append("    ").append(Objects.toString(object).replaceAll("\r\n", "\r\n    ")).append("\r\n");
        }
        return builder.append(")").toString();
    }

    public CommandData(String name, String description, Set<Flag> flags, CommandPermission permission, CommandEnumData aliases, List<ChainedSubCommandData> subcommands, CommandOverloadData[] overloads) {
        this.name = name;
        this.description = description;
        this.flags = flags;
        this.permission = permission;
        this.aliases = aliases;
        this.subcommands = subcommands;
        this.overloads = overloads;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public CommandPermission getPermission() {
        return this.permission;
    }

    public CommandEnumData getAliases() {
        return this.aliases;
    }

    public List<ChainedSubCommandData> getSubcommands() {
        return this.subcommands;
    }

    public CommandOverloadData[] getOverloads() {
        return this.overloads;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandData)) {
            return false;
        }
        CommandData other = (CommandData)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<Flag> this$flags = this.getFlags();
        Set<Flag> other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        CommandPermission this$permission = this.getPermission();
        CommandPermission other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !((Object)((Object)this$permission)).equals((Object)other$permission)) {
            return false;
        }
        CommandEnumData this$aliases = this.getAliases();
        CommandEnumData other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        List<ChainedSubCommandData> this$subcommands = this.getSubcommands();
        List<ChainedSubCommandData> other$subcommands = other.getSubcommands();
        if (this$subcommands == null ? other$subcommands != null : !((Object)this$subcommands).equals(other$subcommands)) {
            return false;
        }
        return Arrays.deepEquals(this.getOverloads(), other.getOverloads());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<Flag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        CommandPermission $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : ((Object)((Object)$permission)).hashCode());
        CommandEnumData $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        List<ChainedSubCommandData> $subcommands = this.getSubcommands();
        result = result * 59 + ($subcommands == null ? 43 : ((Object)$subcommands).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOverloads());
        return result;
    }

    public static enum Flag {
        TEST_USAGE,
        HIDDEN_FROM_COMMAND_BLOCK,
        HIDDEN_FROM_PLAYER,
        HIDDEN_FROM_AUTOMATION,
        LOCAL_SYNC,
        EXECUTE_DISALLOWED,
        MESSAGE_TYPE,
        NOT_CHEAT,
        ASYNC;

    }
}

