/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector4d;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector4d
extends Vector4d {
    private static final long serialVersionUID = 1L;
    private final double x;
    private final double y;
    private final double z;
    private final double w;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector4d(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public double getW() {
        return this.w;
    }

    @Override
    @Nonnull
    public Vector4d add(double x, double y, double z, double w) {
        return Vector4d.from(this.getX() + x, this.getY() + y, this.getZ() + z, this.getW() + w);
    }

    @Override
    @Nonnull
    public Vector4d sub(double x, double y, double z, double w) {
        return Vector4d.from(this.getX() - x, this.getY() - y, this.getZ() - z, this.getW() - w);
    }

    @Override
    @Nonnull
    public Vector4d mul(double x, double y, double z, double w) {
        return Vector4d.from(this.getX() * x, this.getY() * y, this.getZ() * z, this.getW() * w);
    }

    @Override
    @Nonnull
    public Vector4d div(double x, double y, double z, double w) {
        return Vector4d.from(this.getX() / x, this.getY() / y, this.getZ() / z, this.getW() / w);
    }

    @Override
    @Nonnull
    public Vector4d project(double x, double y, double z, double w) {
        double lengthSquared = x * x + y * y + z * z + w * w;
        if (Math.abs(lengthSquared) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        double a = this.dot(x, y, z, w) / lengthSquared;
        return Vector4d.from(a * x, a * y, a * z, a * w);
    }

    @Override
    @Nonnull
    public Vector4d pow(double power) {
        return Vector4d.from(Math.pow(this.getX(), power), Math.pow(this.getY(), power), Math.pow(this.getZ(), power), Math.pow(this.getW(), power));
    }

    @Override
    @Nonnull
    public Vector4d ceil() {
        return Vector4d.from(Math.ceil(this.getX()), Math.ceil(this.getY()), Math.ceil(this.getZ()), Math.ceil(this.getW()));
    }

    @Override
    @Nonnull
    public Vector4d floor() {
        return Vector4d.from(GenericMath.floor(this.getX()), GenericMath.floor(this.getY()), GenericMath.floor(this.getZ()), GenericMath.floor(this.getW()));
    }

    @Override
    @Nonnull
    public Vector4d round() {
        return Vector4d.from(Math.round(this.getX()), Math.round(this.getY()), Math.round(this.getZ()), Math.round(this.getW()));
    }

    @Override
    @Nonnull
    public Vector4d abs() {
        return Vector4d.from(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()), Math.abs(this.getW()));
    }

    @Override
    @Nonnull
    public Vector4d negate() {
        return Vector4d.from(-this.getX(), -this.getY(), -this.getZ(), -this.getW());
    }

    @Override
    @Nonnull
    public Vector4d min(double x, double y, double z, double w) {
        return Vector4d.from(Math.min(this.getX(), x), Math.min(this.getY(), y), Math.min(this.getZ(), z), Math.min(this.getW(), w));
    }

    @Override
    @Nonnull
    public Vector4d max(double x, double y, double z, double w) {
        return Vector4d.from(Math.max(this.getX(), x), Math.max(this.getY(), y), Math.max(this.getZ(), z), Math.max(this.getW(), w));
    }

    @Override
    @Nonnull
    public Vector4d normalize() {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero vector");
        }
        return Vector4d.from(this.getX() / length, this.getY() / length, this.getZ() / length, this.getW() / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector4d)) {
            return false;
        }
        Vector4d vector4 = (Vector4d)o;
        if (Double.compare(vector4.getW(), this.w) != 0) {
            return false;
        }
        if (Double.compare(vector4.getX(), this.x) != 0) {
            return false;
        }
        if (Double.compare(vector4.getY(), this.y) != 0) {
            return false;
        }
        return Double.compare(vector4.getZ(), this.z) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0 ? Double.hashCode(this.x) : 0;
            result = 31 * result + (this.y != 0.0 ? Double.hashCode(this.y) : 0);
            result = 31 * result + (this.z != 0.0 ? Double.hashCode(this.z) : 0);
            this.hashCode = 31 * result + (this.w != 0.0 ? Double.hashCode(this.w) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

