/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.util;

import com.google.gson.JsonObject;
import java.security.KeyPair;
import java.util.Base64;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.util.CryptUtil;

public class JsonUtil {
    public static JsonObject encodeKeyPair(KeyPair keyPair) {
        if (keyPair.getPublic() == null || keyPair.getPrivate() == null) {
            throw new IllegalArgumentException("KeyPair must contain both public and private key");
        }
        if (!keyPair.getPublic().getAlgorithm().equals(keyPair.getPrivate().getAlgorithm())) {
            throw new IllegalArgumentException("Public and private key must use the same algorithm");
        }
        JsonObject json = new JsonObject();
        json.addProperty("algorithm", keyPair.getPublic().getAlgorithm());
        json.addProperty("publicKey", Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded()));
        json.addProperty("privateKey", Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded()));
        return json;
    }

    public static KeyPair decodeKeyPair(GsonObject json) {
        String algorithm;
        switch (algorithm = json.reqString("algorithm")) {
            case "RSA": {
                return new KeyPair(CryptUtil.rsaPublicKeyFromBase64(json.reqString("publicKey")), CryptUtil.rsaPrivateKeyFromBase64(json.reqString("privateKey")));
            }
            case "EC": {
                return new KeyPair(CryptUtil.ecPublicKeyFromBase64(json.reqString("publicKey")), CryptUtil.ecPrivateKeyFromBase64(json.reqString("privateKey")));
            }
        }
        throw new IllegalArgumentException("Unsupported key algorithm: " + algorithm);
    }
}

