/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.model;

import com.google.gson.JsonObject;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.util.Expirable;

public final class MsaDeviceCode
implements Expirable {
    private final long expireTimeMs;
    private final long intervalMs;
    private final String deviceCode;
    private final String userCode;
    private final String verificationUri;

    public static MsaDeviceCode fromJson(JsonObject json) {
        return MsaDeviceCode.fromJson(new GsonObject(json));
    }

    public static MsaDeviceCode fromJson(GsonObject json) {
        return new MsaDeviceCode(json.reqLong("expireTimeMs"), json.reqLong("intervalMs"), json.reqString("deviceCode"), json.reqString("userCode"), json.reqString("verificationUri"));
    }

    public static JsonObject toJson(MsaDeviceCode deviceCode) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", (Number)1);
        json.addProperty("expireTimeMs", (Number)deviceCode.expireTimeMs);
        json.addProperty("intervalMs", (Number)deviceCode.intervalMs);
        json.addProperty("deviceCode", deviceCode.deviceCode);
        json.addProperty("userCode", deviceCode.userCode);
        json.addProperty("verificationUri", deviceCode.verificationUri);
        return json;
    }

    public String getDirectVerificationUri() {
        return this.verificationUri + "?otc=" + this.userCode;
    }

    @Generated
    public MsaDeviceCode(long expireTimeMs, long intervalMs, String deviceCode, String userCode, String verificationUri) {
        this.expireTimeMs = expireTimeMs;
        this.intervalMs = intervalMs;
        this.deviceCode = deviceCode;
        this.userCode = userCode;
        this.verificationUri = verificationUri;
    }

    @Override
    @Generated
    public long getExpireTimeMs() {
        return this.expireTimeMs;
    }

    @Generated
    public long getIntervalMs() {
        return this.intervalMs;
    }

    @Generated
    public String getDeviceCode() {
        return this.deviceCode;
    }

    @Generated
    public String getUserCode() {
        return this.userCode;
    }

    @Generated
    public String getVerificationUri() {
        return this.verificationUri;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MsaDeviceCode)) {
            return false;
        }
        MsaDeviceCode other = (MsaDeviceCode)o;
        if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
            return false;
        }
        if (this.getIntervalMs() != other.getIntervalMs()) {
            return false;
        }
        String this$deviceCode = this.getDeviceCode();
        String other$deviceCode = other.getDeviceCode();
        if (this$deviceCode == null ? other$deviceCode != null : !this$deviceCode.equals(other$deviceCode)) {
            return false;
        }
        String this$userCode = this.getUserCode();
        String other$userCode = other.getUserCode();
        if (this$userCode == null ? other$userCode != null : !this$userCode.equals(other$userCode)) {
            return false;
        }
        String this$verificationUri = this.getVerificationUri();
        String other$verificationUri = other.getVerificationUri();
        return !(this$verificationUri == null ? other$verificationUri != null : !this$verificationUri.equals(other$verificationUri));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expireTimeMs = this.getExpireTimeMs();
        result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
        long $intervalMs = this.getIntervalMs();
        result = result * 59 + (int)($intervalMs >>> 32 ^ $intervalMs);
        String $deviceCode = this.getDeviceCode();
        result = result * 59 + ($deviceCode == null ? 43 : $deviceCode.hashCode());
        String $userCode = this.getUserCode();
        result = result * 59 + ($userCode == null ? 43 : $userCode.hashCode());
        String $verificationUri = this.getVerificationUri();
        result = result * 59 + ($verificationUri == null ? 43 : $verificationUri.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MsaDeviceCode(expireTimeMs=" + this.getExpireTimeMs() + ", intervalMs=" + this.getIntervalMs() + ", deviceCode=" + this.getDeviceCode() + ", userCode=" + this.getUserCode() + ", verificationUri=" + this.getVerificationUri() + ")";
    }
}

