/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.executor;

import java.io.IOException;
import java.net.CookieManager;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.requests.HttpRequest;

public abstract class RequestExecutor {
    @Nonnull
    protected final HttpClient client;

    public RequestExecutor(@Nonnull HttpClient client) {
        this.client = client;
    }

    @Nonnull
    public abstract HttpResponse execute(@Nonnull HttpRequest var1) throws IOException, InterruptedException;

    protected final boolean isFollowRedirects(@Nonnull HttpRequest request) {
        switch (request.getFollowRedirects()) {
            case NOT_SET: {
                return this.client.isFollowRedirects();
            }
            case FOLLOW: {
                return true;
            }
            case IGNORE: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)request.getFollowRedirects()));
    }

    @Nullable
    protected final CookieManager getCookieManager(@Nonnull HttpRequest request) {
        return request.isCookieManagerSet() ? request.getCookieManager() : this.client.getCookieManager();
    }

    protected final boolean isIgnoreInvalidSSL(@Nonnull HttpRequest request) {
        return request.isIgnoreInvalidSSLSet() ? request.getIgnoreInvalidSSL() : this.client.isIgnoreInvalidSSL();
    }

    protected final Map<String, List<String>> getHeaders(@Nonnull HttpRequest request, @Nullable CookieManager cookieManager) throws IOException {
        return this.getHeaders(request, cookieManager, true);
    }

    protected final Map<String, List<String>> getHeaders(@Nonnull HttpRequest request, @Nullable CookieManager cookieManager, boolean includeContentHeaders) throws IOException {
        HttpContent content;
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (cookieManager != null) {
            try {
                Map<String, List<String>> cookieHeaders = cookieManager.get(request.getURL().toURI(), Collections.emptyMap());
                for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    headers.put(entry.getKey().toLowerCase(), entry.getValue());
                }
            }
            catch (URISyntaxException e) {
                throw new IOException("Failed to parse URL as URI", e);
            }
        }
        if (request instanceof HttpContentRequest && includeContentHeaders && (content = ((HttpContentRequest)request).getContent()) != null) {
            headers.put("Content-Type".toLowerCase(), Collections.singletonList(content.getType().toString()));
            if (content.getLength() < 0) {
                headers.put("Content-Length".toLowerCase(), Collections.singletonList(String.valueOf(content.getLength())));
            }
        }
        for (Map.Entry<String, List<String>> entry : this.client.getHeaders().entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            headers.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            headers.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        return headers;
    }

    protected final void updateCookies(@Nullable CookieManager cookieManager, URL url, Map<String, List<String>> headers) throws IOException {
        if (cookieManager == null) {
            return;
        }
        try {
            cookieManager.put(url.toURI(), headers);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to parse URL as URI", e);
        }
    }

    protected final void setHeaders(Map<String, List<String>> headers, BiConsumer<String, String> setConsumer, BiConsumer<String, String> addConsumer) {
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if ("Cookie".equalsIgnoreCase(entry.getKey())) {
                setConsumer.accept(entry.getKey(), String.join((CharSequence)"; ", (Iterable<? extends CharSequence>)entry.getValue()));
                continue;
            }
            boolean first = true;
            for (String val : entry.getValue()) {
                if (first) {
                    first = false;
                    setConsumer.accept(entry.getKey(), val);
                    continue;
                }
                addConsumer.accept(entry.getKey(), val);
            }
        }
    }
}

