/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.CustomItemBedrockOptions;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.component.DataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.DataComponentMap;
import org.geysermc.geyser.api.predicate.MinecraftPredicate;
import org.geysermc.geyser.api.predicate.PredicateStrategy;
import org.geysermc.geyser.api.predicate.context.item.ItemPredicateContext;
import org.geysermc.geyser.api.util.GeyserProvided;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.impl.GeyserCoreProvided;
import org.geysermc.geyser.item.custom.GeyserNonVanillaCustomItemDefinition;
import org.geysermc.geyser.item.custom.impl.DataComponentImpl;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;

public class GeyserCustomItemDefinition
implements CustomItemDefinition {
    private final @NonNull Identifier bedrockIdentifier;
    private final @NonNull String displayName;
    private final @NonNull Identifier model;
    private final @NonNull String icon;
    private final @NonNull List<MinecraftPredicate<? super ItemPredicateContext>> predicates;
    private final PredicateStrategy predicateStrategy;
    private final int priority;
    private final @NonNull CustomItemBedrockOptions bedrockOptions;
    private final @NonNull DataComponentMap components;
    private final @NonNull List<Identifier> removedComponents;

    public GeyserCustomItemDefinition(Builder builder) {
        this.bedrockIdentifier = builder.bedrockIdentifier;
        this.displayName = builder.displayName;
        this.model = builder.model;
        String setIcon = builder.bedrockOptions.icon();
        this.icon = setIcon == null ? this.bedrockIdentifier().toString().replaceAll(":", ".").replaceAll("/", "_") : setIcon;
        this.predicates = List.copyOf(builder.predicates);
        this.predicateStrategy = builder.predicateStrategy;
        this.priority = builder.priority;
        this.bedrockOptions = builder.bedrockOptions;
        this.components = new ComponentMap(builder.components);
        this.removedComponents = builder.removedComponents;
    }

    @Override
    public @NonNull Identifier bedrockIdentifier() {
        return this.bedrockIdentifier;
    }

    @Override
    public @NonNull String displayName() {
        return this.displayName;
    }

    @Override
    public @NonNull Identifier model() {
        return this.model;
    }

    @Override
    public @NonNull String icon() {
        return this.icon;
    }

    @Override
    public @NonNull List<MinecraftPredicate<? super ItemPredicateContext>> predicates() {
        return this.predicates;
    }

    @Override
    public @NonNull PredicateStrategy predicateStrategy() {
        return this.predicateStrategy;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public @NonNull CustomItemBedrockOptions bedrockOptions() {
        return this.bedrockOptions;
    }

    @Override
    public @NonNull DataComponentMap components() {
        return this.components;
    }

    @Override
    public @NonNull List<Identifier> removedComponents() {
        return this.removedComponents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserCustomItemDefinition)) {
            return false;
        }
        GeyserCustomItemDefinition other = (GeyserCustomItemDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        Identifier this$bedrockIdentifier = this.bedrockIdentifier;
        Identifier other$bedrockIdentifier = other.bedrockIdentifier;
        if (this$bedrockIdentifier == null ? other$bedrockIdentifier != null : !this$bedrockIdentifier.equals(other$bedrockIdentifier)) {
            return false;
        }
        String this$displayName = this.displayName;
        String other$displayName = other.displayName;
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Identifier this$model = this.model;
        Identifier other$model = other.model;
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$icon = this.icon;
        String other$icon = other.icon;
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        List<MinecraftPredicate<? super ItemPredicateContext>> this$predicates = this.predicates;
        List<MinecraftPredicate<? super ItemPredicateContext>> other$predicates = other.predicates;
        if (this$predicates == null ? other$predicates != null : !((Object)this$predicates).equals(other$predicates)) {
            return false;
        }
        PredicateStrategy this$predicateStrategy = this.predicateStrategy;
        PredicateStrategy other$predicateStrategy = other.predicateStrategy;
        if (this$predicateStrategy == null ? other$predicateStrategy != null : !((Object)((Object)this$predicateStrategy)).equals((Object)other$predicateStrategy)) {
            return false;
        }
        CustomItemBedrockOptions this$bedrockOptions = this.bedrockOptions;
        CustomItemBedrockOptions other$bedrockOptions = other.bedrockOptions;
        if (this$bedrockOptions == null ? other$bedrockOptions != null : !this$bedrockOptions.equals(other$bedrockOptions)) {
            return false;
        }
        DataComponentMap this$components = this.components;
        DataComponentMap other$components = other.components;
        if (this$components == null ? other$components != null : !this$components.equals(other$components)) {
            return false;
        }
        List<Identifier> this$removedComponents = this.removedComponents;
        List<Identifier> other$removedComponents = other.removedComponents;
        return !(this$removedComponents == null ? other$removedComponents != null : !((Object)this$removedComponents).equals(other$removedComponents));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeyserCustomItemDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.priority;
        Identifier $bedrockIdentifier = this.bedrockIdentifier;
        result = result * 59 + ($bedrockIdentifier == null ? 43 : $bedrockIdentifier.hashCode());
        String $displayName = this.displayName;
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Identifier $model = this.model;
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $icon = this.icon;
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        List<MinecraftPredicate<? super ItemPredicateContext>> $predicates = this.predicates;
        result = result * 59 + ($predicates == null ? 43 : ((Object)$predicates).hashCode());
        PredicateStrategy $predicateStrategy = this.predicateStrategy;
        result = result * 59 + ($predicateStrategy == null ? 43 : ((Object)((Object)$predicateStrategy)).hashCode());
        CustomItemBedrockOptions $bedrockOptions = this.bedrockOptions;
        result = result * 59 + ($bedrockOptions == null ? 43 : $bedrockOptions.hashCode());
        DataComponentMap $components = this.components;
        result = result * 59 + ($components == null ? 43 : $components.hashCode());
        List<Identifier> $removedComponents = this.removedComponents;
        result = result * 59 + ($removedComponents == null ? 43 : ((Object)$removedComponents).hashCode());
        return result;
    }

    public String toString() {
        return "GeyserCustomItemDefinition(bedrockIdentifier=" + String.valueOf(this.bedrockIdentifier) + ", displayName=" + this.displayName + ", model=" + String.valueOf(this.model) + ", icon=" + this.icon + ", predicates=" + String.valueOf(this.predicates) + ", predicateStrategy=" + String.valueOf((Object)this.predicateStrategy) + ", priority=" + this.priority + ", bedrockOptions=" + String.valueOf(this.bedrockOptions) + ", components=" + String.valueOf(this.components) + ", removedComponents=" + String.valueOf(this.removedComponents) + ")";
    }

    public static class Builder
    implements CustomItemDefinition.Builder {
        private final Identifier bedrockIdentifier;
        private final Identifier model;
        private final List<MinecraftPredicate<? super ItemPredicateContext>> predicates = new ArrayList<MinecraftPredicate<? super ItemPredicateContext>>();
        private final Reference2ObjectMap<DataComponent<?>, Object> components = new Reference2ObjectOpenHashMap();
        private final List<Identifier> removedComponents = new ArrayList<Identifier>();
        private String displayName;
        private int priority = 0;
        private CustomItemBedrockOptions bedrockOptions = CustomItemBedrockOptions.builder().build();
        private PredicateStrategy predicateStrategy = PredicateStrategy.AND;

        public Builder(@NonNull Identifier bedrockIdentifier, @NonNull Identifier model) {
            Objects.requireNonNull(bedrockIdentifier, "bedrockIdentifier cannot be null");
            Objects.requireNonNull(model, "model cannot be null");
            this.bedrockIdentifier = bedrockIdentifier;
            this.displayName = bedrockIdentifier.toString();
            this.model = model;
        }

        @Override
        public CustomItemDefinition.Builder displayName(@NonNull String displayName) {
            Objects.requireNonNull(displayName, "displayName cannot be null");
            this.displayName = displayName;
            return this;
        }

        @Override
        public CustomItemDefinition.Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public CustomItemDefinition.Builder bedrockOptions(@NonNull CustomItemBedrockOptions.Builder options) {
            Objects.requireNonNull(options, "options cannot be null");
            this.bedrockOptions = options.build();
            return this;
        }

        @Override
        public CustomItemDefinition.Builder predicate(@NonNull MinecraftPredicate<? super ItemPredicateContext> predicate) {
            Objects.requireNonNull(predicate, "predicate cannot be null");
            if (predicate instanceof GeyserProvided && !(predicate instanceof GeyserCoreProvided)) {
                throw new IllegalArgumentException("found custom implementation (%s) of Geyser-provided predicate! Use the predicate creators provided in the api instead.".formatted(predicate.getClass().getSimpleName()));
            }
            this.predicates.add(predicate);
            return this;
        }

        @Override
        public CustomItemDefinition.Builder predicateStrategy(@NonNull PredicateStrategy strategy) {
            Objects.requireNonNull(strategy, "strategy cannot be null");
            this.predicateStrategy = strategy;
            return this;
        }

        @Override
        public <T> CustomItemDefinition.Builder component(@NonNull DataComponent<T> component, @NonNull T value) {
            Objects.requireNonNull(component, "component cannot be null");
            Objects.requireNonNull(value, "value cannot be null");
            if (!(component instanceof DataComponentImpl)) {
                throw new IllegalArgumentException("Cannot use custom implementations of the DataComponent<T> interface! Found: " + component.getClass().getSimpleName());
            }
            DataComponentImpl dataComponent = (DataComponentImpl)component;
            if (this.removedComponents.contains(component.identifier())) {
                throw new IllegalArgumentException("Tried to add earlier removed component " + String.valueOf(component.identifier()));
            }
            if (!component.vanilla() && !(this instanceof GeyserNonVanillaCustomItemDefinition.Builder)) {
                throw new IllegalArgumentException("That component cannot be used for vanilla items");
            }
            if (!dataComponent.validate(value)) {
                throw new IllegalArgumentException("Value " + String.valueOf(value) + " is invalid for " + String.valueOf(component));
            }
            this.components.put(component, value);
            return this;
        }

        @Override
        public CustomItemDefinition.Builder removeComponent(@NonNull Identifier component) {
            Objects.requireNonNull(component, "component cannot be null");
            if (this.components.keySet().stream().map(DataComponent::identifier).anyMatch(identifier -> identifier.equals(component))) {
                throw new IllegalArgumentException("Tried to remove earlier added component " + String.valueOf(component));
            }
            this.removedComponents.add(component);
            return this;
        }

        @Override
        public CustomItemDefinition build() {
            return new GeyserCustomItemDefinition(this);
        }
    }

    private record ComponentMap(Reference2ObjectMap<DataComponent<?>, Object> components) implements DataComponentMap
    {
        @Override
        public <T> T get(DataComponent<T> type) {
            return (T)this.components.get(type);
        }

        @Override
        public Set<DataComponent<?>> keySet() {
            return this.components.keySet();
        }
    }
}

