/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3d;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.WeightedList;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.Particle;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.BuiltinSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.CustomSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;
import org.jetbrains.annotations.Nullable;

public class ClientboundExplodePacket
implements MinecraftPacket {
    private final Vector3d center;
    private final float radius;
    private final int blockCount;
    @Nullable
    private final Vector3d playerKnockback;
    @lombok.NonNull
    private final Particle explosionParticle;
    @lombok.NonNull
    private final Sound explosionSound;
    @lombok.NonNull
    private final WeightedList<BlockParticleInfo> blockParticles;

    public ClientboundExplodePacket(ByteBuf in) {
        this.center = Vector3d.from(in.readDouble(), in.readDouble(), in.readDouble());
        this.radius = in.readFloat();
        this.blockCount = in.readInt();
        this.playerKnockback = MinecraftTypes.readNullable(in, input -> Vector3d.from(input.readDouble(), input.readDouble(), input.readDouble()));
        this.explosionParticle = MinecraftTypes.readParticle(in);
        this.explosionSound = MinecraftTypes.readById(in, BuiltinSound::from, MinecraftTypes::readSoundEvent);
        this.blockParticles = new WeightedList<BlockParticleInfo>(in, BlockParticleInfo::new);
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeDouble(this.center.getX());
        out.writeDouble(this.center.getY());
        out.writeDouble(this.center.getZ());
        out.writeFloat(this.radius);
        out.writeInt(this.blockCount);
        MinecraftTypes.writeNullable(out, this.playerKnockback, (output, playerKnockback) -> {
            output.writeDouble(playerKnockback.getX());
            output.writeDouble(playerKnockback.getY());
            output.writeDouble(playerKnockback.getZ());
        });
        MinecraftTypes.writeParticle(out, this.explosionParticle);
        if (this.explosionSound instanceof CustomSound) {
            MinecraftTypes.writeVarInt(out, 0);
            MinecraftTypes.writeSoundEvent(out, this.explosionSound);
        } else {
            MinecraftTypes.writeVarInt(out, ((BuiltinSound)this.explosionSound).ordinal() + 1);
        }
        this.blockParticles.write(out, BlockParticleInfo::write);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3d getCenter() {
        return this.center;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    @Nullable
    public Vector3d getPlayerKnockback() {
        return this.playerKnockback;
    }

    @lombok.NonNull
    public Particle getExplosionParticle() {
        return this.explosionParticle;
    }

    @lombok.NonNull
    public Sound getExplosionSound() {
        return this.explosionSound;
    }

    @lombok.NonNull
    public WeightedList<BlockParticleInfo> getBlockParticles() {
        return this.blockParticles;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundExplodePacket)) {
            return false;
        }
        ClientboundExplodePacket other = (ClientboundExplodePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        if (this.getBlockCount() != other.getBlockCount()) {
            return false;
        }
        Vector3d this$center = this.getCenter();
        Vector3d other$center = other.getCenter();
        if (this$center == null ? other$center != null : !this$center.equals(other$center)) {
            return false;
        }
        Vector3d this$playerKnockback = this.getPlayerKnockback();
        Vector3d other$playerKnockback = other.getPlayerKnockback();
        if (this$playerKnockback == null ? other$playerKnockback != null : !this$playerKnockback.equals(other$playerKnockback)) {
            return false;
        }
        Particle this$explosionParticle = this.getExplosionParticle();
        Particle other$explosionParticle = other.getExplosionParticle();
        if (this$explosionParticle == null ? other$explosionParticle != null : !((Object)this$explosionParticle).equals(other$explosionParticle)) {
            return false;
        }
        Sound this$explosionSound = this.getExplosionSound();
        Sound other$explosionSound = other.getExplosionSound();
        if (this$explosionSound == null ? other$explosionSound != null : !this$explosionSound.equals(other$explosionSound)) {
            return false;
        }
        WeightedList<BlockParticleInfo> this$blockParticles = this.getBlockParticles();
        WeightedList<BlockParticleInfo> other$blockParticles = other.getBlockParticles();
        return !(this$blockParticles == null ? other$blockParticles != null : !((Object)this$blockParticles).equals(other$blockParticles));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof ClientboundExplodePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getRadius());
        result = result * 59 + this.getBlockCount();
        Vector3d $center = this.getCenter();
        result = result * 59 + ($center == null ? 43 : $center.hashCode());
        Vector3d $playerKnockback = this.getPlayerKnockback();
        result = result * 59 + ($playerKnockback == null ? 43 : $playerKnockback.hashCode());
        Particle $explosionParticle = this.getExplosionParticle();
        result = result * 59 + ($explosionParticle == null ? 43 : ((Object)$explosionParticle).hashCode());
        Sound $explosionSound = this.getExplosionSound();
        result = result * 59 + ($explosionSound == null ? 43 : $explosionSound.hashCode());
        WeightedList<BlockParticleInfo> $blockParticles = this.getBlockParticles();
        result = result * 59 + ($blockParticles == null ? 43 : ((Object)$blockParticles).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundExplodePacket(center=" + String.valueOf(this.getCenter()) + ", radius=" + this.getRadius() + ", blockCount=" + this.getBlockCount() + ", playerKnockback=" + String.valueOf(this.getPlayerKnockback()) + ", explosionParticle=" + String.valueOf(this.getExplosionParticle()) + ", explosionSound=" + String.valueOf(this.getExplosionSound()) + ", blockParticles=" + String.valueOf(this.getBlockParticles()) + ")";
    }

    public @NonNull ClientboundExplodePacket withCenter(Vector3d center) {
        return this.center == center ? this : new ClientboundExplodePacket(center, this.radius, this.blockCount, this.playerKnockback, this.explosionParticle, this.explosionSound, this.blockParticles);
    }

    public @NonNull ClientboundExplodePacket withRadius(float radius) {
        return this.radius == radius ? this : new ClientboundExplodePacket(this.center, radius, this.blockCount, this.playerKnockback, this.explosionParticle, this.explosionSound, this.blockParticles);
    }

    public @NonNull ClientboundExplodePacket withBlockCount(int blockCount) {
        return this.blockCount == blockCount ? this : new ClientboundExplodePacket(this.center, this.radius, blockCount, this.playerKnockback, this.explosionParticle, this.explosionSound, this.blockParticles);
    }

    public @NonNull ClientboundExplodePacket withPlayerKnockback(@Nullable Vector3d playerKnockback) {
        return this.playerKnockback == playerKnockback ? this : new ClientboundExplodePacket(this.center, this.radius, this.blockCount, playerKnockback, this.explosionParticle, this.explosionSound, this.blockParticles);
    }

    public @NonNull ClientboundExplodePacket withExplosionParticle(@lombok.NonNull Particle explosionParticle) {
        if (explosionParticle == null) {
            throw new NullPointerException("explosionParticle is marked non-null but is null");
        }
        return this.explosionParticle == explosionParticle ? this : new ClientboundExplodePacket(this.center, this.radius, this.blockCount, this.playerKnockback, explosionParticle, this.explosionSound, this.blockParticles);
    }

    public @NonNull ClientboundExplodePacket withExplosionSound(@lombok.NonNull Sound explosionSound) {
        if (explosionSound == null) {
            throw new NullPointerException("explosionSound is marked non-null but is null");
        }
        return this.explosionSound == explosionSound ? this : new ClientboundExplodePacket(this.center, this.radius, this.blockCount, this.playerKnockback, this.explosionParticle, explosionSound, this.blockParticles);
    }

    public @NonNull ClientboundExplodePacket withBlockParticles(@lombok.NonNull WeightedList<BlockParticleInfo> blockParticles) {
        if (blockParticles == null) {
            throw new NullPointerException("blockParticles is marked non-null but is null");
        }
        return this.blockParticles == blockParticles ? this : new ClientboundExplodePacket(this.center, this.radius, this.blockCount, this.playerKnockback, this.explosionParticle, this.explosionSound, blockParticles);
    }

    public ClientboundExplodePacket(Vector3d center, float radius, int blockCount, @Nullable Vector3d playerKnockback, @lombok.NonNull Particle explosionParticle, @lombok.NonNull Sound explosionSound, @lombok.NonNull WeightedList<BlockParticleInfo> blockParticles) {
        if (explosionParticle == null) {
            throw new NullPointerException("explosionParticle is marked non-null but is null");
        }
        if (explosionSound == null) {
            throw new NullPointerException("explosionSound is marked non-null but is null");
        }
        if (blockParticles == null) {
            throw new NullPointerException("blockParticles is marked non-null but is null");
        }
        this.center = center;
        this.radius = radius;
        this.blockCount = blockCount;
        this.playerKnockback = playerKnockback;
        this.explosionParticle = explosionParticle;
        this.explosionSound = explosionSound;
        this.blockParticles = blockParticles;
    }

    public record BlockParticleInfo(Particle particle, float scaling, float speed) {
        public BlockParticleInfo(ByteBuf in) {
            this(MinecraftTypes.readParticle(in), in.readFloat(), in.readFloat());
        }

        public void write(ByteBuf out) {
            MinecraftTypes.writeParticle(out, this.particle);
            out.writeFloat(this.scaling);
            out.writeFloat(this.speed);
        }
    }
}

