/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundRecipeBookSettingsPacket
implements MinecraftPacket {
    private final TypeSettings crafting;
    private final TypeSettings furnace;
    private final TypeSettings blastFurnace;
    private final TypeSettings smoker;

    public ClientboundRecipeBookSettingsPacket(ByteBuf in) {
        this.crafting = new TypeSettings(in.readBoolean(), in.readBoolean());
        this.furnace = new TypeSettings(in.readBoolean(), in.readBoolean());
        this.blastFurnace = new TypeSettings(in.readBoolean(), in.readBoolean());
        this.smoker = new TypeSettings(in.readBoolean(), in.readBoolean());
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeBoolean(this.crafting.open());
        out.writeBoolean(this.crafting.filtering());
        out.writeBoolean(this.furnace.open());
        out.writeBoolean(this.furnace.filtering());
        out.writeBoolean(this.blastFurnace.open());
        out.writeBoolean(this.blastFurnace.filtering());
        out.writeBoolean(this.smoker.open());
        out.writeBoolean(this.smoker.filtering());
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public TypeSettings getCrafting() {
        return this.crafting;
    }

    public TypeSettings getFurnace() {
        return this.furnace;
    }

    public TypeSettings getBlastFurnace() {
        return this.blastFurnace;
    }

    public TypeSettings getSmoker() {
        return this.smoker;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRecipeBookSettingsPacket)) {
            return false;
        }
        ClientboundRecipeBookSettingsPacket other = (ClientboundRecipeBookSettingsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TypeSettings this$crafting = this.getCrafting();
        TypeSettings other$crafting = other.getCrafting();
        if (this$crafting == null ? other$crafting != null : !((Object)this$crafting).equals(other$crafting)) {
            return false;
        }
        TypeSettings this$furnace = this.getFurnace();
        TypeSettings other$furnace = other.getFurnace();
        if (this$furnace == null ? other$furnace != null : !((Object)this$furnace).equals(other$furnace)) {
            return false;
        }
        TypeSettings this$blastFurnace = this.getBlastFurnace();
        TypeSettings other$blastFurnace = other.getBlastFurnace();
        if (this$blastFurnace == null ? other$blastFurnace != null : !((Object)this$blastFurnace).equals(other$blastFurnace)) {
            return false;
        }
        TypeSettings this$smoker = this.getSmoker();
        TypeSettings other$smoker = other.getSmoker();
        return !(this$smoker == null ? other$smoker != null : !((Object)this$smoker).equals(other$smoker));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRecipeBookSettingsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeSettings $crafting = this.getCrafting();
        result = result * 59 + ($crafting == null ? 43 : ((Object)$crafting).hashCode());
        TypeSettings $furnace = this.getFurnace();
        result = result * 59 + ($furnace == null ? 43 : ((Object)$furnace).hashCode());
        TypeSettings $blastFurnace = this.getBlastFurnace();
        result = result * 59 + ($blastFurnace == null ? 43 : ((Object)$blastFurnace).hashCode());
        TypeSettings $smoker = this.getSmoker();
        result = result * 59 + ($smoker == null ? 43 : ((Object)$smoker).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRecipeBookSettingsPacket(crafting=" + String.valueOf(this.getCrafting()) + ", furnace=" + String.valueOf(this.getFurnace()) + ", blastFurnace=" + String.valueOf(this.getBlastFurnace()) + ", smoker=" + String.valueOf(this.getSmoker()) + ")";
    }

    public @NonNull ClientboundRecipeBookSettingsPacket withCrafting(TypeSettings crafting) {
        return this.crafting == crafting ? this : new ClientboundRecipeBookSettingsPacket(crafting, this.furnace, this.blastFurnace, this.smoker);
    }

    public @NonNull ClientboundRecipeBookSettingsPacket withFurnace(TypeSettings furnace) {
        return this.furnace == furnace ? this : new ClientboundRecipeBookSettingsPacket(this.crafting, furnace, this.blastFurnace, this.smoker);
    }

    public @NonNull ClientboundRecipeBookSettingsPacket withBlastFurnace(TypeSettings blastFurnace) {
        return this.blastFurnace == blastFurnace ? this : new ClientboundRecipeBookSettingsPacket(this.crafting, this.furnace, blastFurnace, this.smoker);
    }

    public @NonNull ClientboundRecipeBookSettingsPacket withSmoker(TypeSettings smoker) {
        return this.smoker == smoker ? this : new ClientboundRecipeBookSettingsPacket(this.crafting, this.furnace, this.blastFurnace, smoker);
    }

    public ClientboundRecipeBookSettingsPacket(TypeSettings crafting, TypeSettings furnace, TypeSettings blastFurnace, TypeSettings smoker) {
        this.crafting = crafting;
        this.furnace = furnace;
        this.blastFurnace = blastFurnace;
        this.smoker = smoker;
    }

    private record TypeSettings(boolean open, boolean filtering) {
    }
}

