/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;
import org.jetbrains.annotations.Nullable;

public record KineticWeapon(int contactCooldownTicks, int delayTicks, @Nullable Condition dismountConditions, @Nullable Condition knockbackConditions, @Nullable Condition damageConditions, float forwardMovement, float damageMultiplier, @Nullable Sound sound, @Nullable Sound hitSound) {
    public static @NonNull KineticWeaponBuilder builder() {
        return new KineticWeaponBuilder();
    }

    public @NonNull KineticWeaponBuilder toBuilder() {
        return new KineticWeaponBuilder().contactCooldownTicks(this.contactCooldownTicks).delayTicks(this.delayTicks).dismountConditions(this.dismountConditions).knockbackConditions(this.knockbackConditions).damageConditions(this.damageConditions).forwardMovement(this.forwardMovement).damageMultiplier(this.damageMultiplier).sound(this.sound).hitSound(this.hitSound);
    }

    public record Condition(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public static @NonNull ConditionBuilder builder() {
            return new ConditionBuilder();
        }

        public @NonNull ConditionBuilder toBuilder() {
            return new ConditionBuilder().maxDurationTicks(this.maxDurationTicks).minSpeed(this.minSpeed).minRelativeSpeed(this.minRelativeSpeed);
        }

        public static class ConditionBuilder {
            private int maxDurationTicks;
            private float minSpeed;
            private float minRelativeSpeed;

            ConditionBuilder() {
            }

            public @NonNull ConditionBuilder maxDurationTicks(int maxDurationTicks) {
                this.maxDurationTicks = maxDurationTicks;
                return this;
            }

            public @NonNull ConditionBuilder minSpeed(float minSpeed) {
                this.minSpeed = minSpeed;
                return this;
            }

            public @NonNull ConditionBuilder minRelativeSpeed(float minRelativeSpeed) {
                this.minRelativeSpeed = minRelativeSpeed;
                return this;
            }

            public @NonNull Condition build() {
                return new Condition(this.maxDurationTicks, this.minSpeed, this.minRelativeSpeed);
            }

            public @NonNull String toString() {
                return "KineticWeapon.Condition.ConditionBuilder(maxDurationTicks=" + this.maxDurationTicks + ", minSpeed=" + this.minSpeed + ", minRelativeSpeed=" + this.minRelativeSpeed + ")";
            }
        }
    }

    public static class KineticWeaponBuilder {
        private int contactCooldownTicks;
        private int delayTicks;
        private Condition dismountConditions;
        private Condition knockbackConditions;
        private Condition damageConditions;
        private float forwardMovement;
        private float damageMultiplier;
        private Sound sound;
        private Sound hitSound;

        KineticWeaponBuilder() {
        }

        public @NonNull KineticWeaponBuilder contactCooldownTicks(int contactCooldownTicks) {
            this.contactCooldownTicks = contactCooldownTicks;
            return this;
        }

        public @NonNull KineticWeaponBuilder delayTicks(int delayTicks) {
            this.delayTicks = delayTicks;
            return this;
        }

        public @NonNull KineticWeaponBuilder dismountConditions(@Nullable Condition dismountConditions) {
            this.dismountConditions = dismountConditions;
            return this;
        }

        public @NonNull KineticWeaponBuilder knockbackConditions(@Nullable Condition knockbackConditions) {
            this.knockbackConditions = knockbackConditions;
            return this;
        }

        public @NonNull KineticWeaponBuilder damageConditions(@Nullable Condition damageConditions) {
            this.damageConditions = damageConditions;
            return this;
        }

        public @NonNull KineticWeaponBuilder forwardMovement(float forwardMovement) {
            this.forwardMovement = forwardMovement;
            return this;
        }

        public @NonNull KineticWeaponBuilder damageMultiplier(float damageMultiplier) {
            this.damageMultiplier = damageMultiplier;
            return this;
        }

        public @NonNull KineticWeaponBuilder sound(@Nullable Sound sound) {
            this.sound = sound;
            return this;
        }

        public @NonNull KineticWeaponBuilder hitSound(@Nullable Sound hitSound) {
            this.hitSound = hitSound;
            return this;
        }

        public @NonNull KineticWeapon build() {
            return new KineticWeapon(this.contactCooldownTicks, this.delayTicks, this.dismountConditions, this.knockbackConditions, this.damageConditions, this.forwardMovement, this.damageMultiplier, this.sound, this.hitSound);
        }

        public @NonNull String toString() {
            return "KineticWeapon.KineticWeaponBuilder(contactCooldownTicks=" + this.contactCooldownTicks + ", delayTicks=" + this.delayTicks + ", dismountConditions=" + String.valueOf(this.dismountConditions) + ", knockbackConditions=" + String.valueOf(this.knockbackConditions) + ", damageConditions=" + String.valueOf(this.damageConditions) + ", forwardMovement=" + this.forwardMovement + ", damageMultiplier=" + this.damageMultiplier + ", sound=" + String.valueOf(this.sound) + ", hitSound=" + String.valueOf(this.hitSound) + ")";
        }
    }
}

