/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.inventory;

import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;

public class VillagerTrade {
    @lombok.NonNull
    private final ItemCost itemCostA;
    @lombok.NonNull
    private final ItemStack result;
    private final @Nullable ItemCost itemCostB;
    private final boolean outOfStock;
    private final int uses;
    private final int maxUses;
    private final int xp;
    private final int specialPriceDiff;
    private final float priceMultiplier;
    private final int demand;

    @lombok.NonNull
    public ItemCost getItemCostA() {
        return this.itemCostA;
    }

    @lombok.NonNull
    public ItemStack getResult() {
        return this.result;
    }

    public @Nullable ItemCost getItemCostB() {
        return this.itemCostB;
    }

    public boolean isOutOfStock() {
        return this.outOfStock;
    }

    public int getUses() {
        return this.uses;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public int getXp() {
        return this.xp;
    }

    public int getSpecialPriceDiff() {
        return this.specialPriceDiff;
    }

    public float getPriceMultiplier() {
        return this.priceMultiplier;
    }

    public int getDemand() {
        return this.demand;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VillagerTrade)) {
            return false;
        }
        VillagerTrade other = (VillagerTrade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOutOfStock() != other.isOutOfStock()) {
            return false;
        }
        if (this.getUses() != other.getUses()) {
            return false;
        }
        if (this.getMaxUses() != other.getMaxUses()) {
            return false;
        }
        if (this.getXp() != other.getXp()) {
            return false;
        }
        if (this.getSpecialPriceDiff() != other.getSpecialPriceDiff()) {
            return false;
        }
        if (Float.compare(this.getPriceMultiplier(), other.getPriceMultiplier()) != 0) {
            return false;
        }
        if (this.getDemand() != other.getDemand()) {
            return false;
        }
        ItemCost this$itemCostA = this.getItemCostA();
        ItemCost other$itemCostA = other.getItemCostA();
        if (this$itemCostA == null ? other$itemCostA != null : !((Object)this$itemCostA).equals(other$itemCostA)) {
            return false;
        }
        ItemStack this$result = this.getResult();
        ItemStack other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        ItemCost this$itemCostB = this.getItemCostB();
        ItemCost other$itemCostB = other.getItemCostB();
        return !(this$itemCostB == null ? other$itemCostB != null : !((Object)this$itemCostB).equals(other$itemCostB));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof VillagerTrade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOutOfStock() ? 79 : 97);
        result = result * 59 + this.getUses();
        result = result * 59 + this.getMaxUses();
        result = result * 59 + this.getXp();
        result = result * 59 + this.getSpecialPriceDiff();
        result = result * 59 + Float.floatToIntBits(this.getPriceMultiplier());
        result = result * 59 + this.getDemand();
        ItemCost $itemCostA = this.getItemCostA();
        result = result * 59 + ($itemCostA == null ? 43 : ((Object)$itemCostA).hashCode());
        ItemStack $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        ItemCost $itemCostB = this.getItemCostB();
        result = result * 59 + ($itemCostB == null ? 43 : ((Object)$itemCostB).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "VillagerTrade(itemCostA=" + String.valueOf(this.getItemCostA()) + ", result=" + String.valueOf(this.getResult()) + ", itemCostB=" + String.valueOf(this.getItemCostB()) + ", outOfStock=" + this.isOutOfStock() + ", uses=" + this.getUses() + ", maxUses=" + this.getMaxUses() + ", xp=" + this.getXp() + ", specialPriceDiff=" + this.getSpecialPriceDiff() + ", priceMultiplier=" + this.getPriceMultiplier() + ", demand=" + this.getDemand() + ")";
    }

    public VillagerTrade(@lombok.NonNull ItemCost itemCostA, @lombok.NonNull ItemStack result, @Nullable ItemCost itemCostB, boolean outOfStock, int uses, int maxUses, int xp, int specialPriceDiff, float priceMultiplier, int demand) {
        if (itemCostA == null) {
            throw new NullPointerException("itemCostA is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.itemCostA = itemCostA;
        this.result = result;
        this.itemCostB = itemCostB;
        this.outOfStock = outOfStock;
        this.uses = uses;
        this.maxUses = maxUses;
        this.xp = xp;
        this.specialPriceDiff = specialPriceDiff;
        this.priceMultiplier = priceMultiplier;
        this.demand = demand;
    }

    public record ItemCost(int itemId, int count, Map<DataComponentType<?>, DataComponent<?, ?>> components) {
    }
}

