/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventGenericPacket;
import org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundSystemChatPacket;

@Translator(packet=ClientboundSystemChatPacket.class)
public class JavaSystemChatTranslator
extends PacketTranslator<ClientboundSystemChatPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSystemChatPacket packet) {
        Component component = packet.getContent();
        if (component instanceof TranslatableComponent) {
            TranslatableComponent component2 = (TranslatableComponent)component;
            if (component2.key().equals("chat.disabled.missingProfileKey")) {
                if (Boolean.parseBoolean(System.getProperty("Geyser.PrintSecureChatInformation", "true"))) {
                    session.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.chat.secure_info_1", session.locale()));
                    session.sendMessage(GeyserLocale.getPlayerLocaleString("geyser.chat.secure_info_2", session.locale(), "https://geysermc.link/secure-chat"));
                }
            } else if (component2.key().equals("sleep.players_sleeping")) {
                if (component2.arguments().size() == 2) {
                    Integer numPlayersSleeping = JavaSystemChatTranslator.convertToInt((TranslationArgument)component2.arguments().get(0));
                    Integer totalPlayersNeeded = JavaSystemChatTranslator.convertToInt((TranslationArgument)component2.arguments().get(1));
                    if (numPlayersSleeping != null && totalPlayersNeeded != null) {
                        LevelEventGenericPacket sleepInfoPacket = new LevelEventGenericPacket();
                        sleepInfoPacket.setType(LevelEvent.SLEEPING_PLAYERS);
                        sleepInfoPacket.setTag(NbtMap.builder().putInt("ableToSleep", totalPlayersNeeded).putInt("overworldPlayerCount", totalPlayersNeeded).putInt("sleepingPlayerCount", numPlayersSleeping).build());
                        session.sendUpstreamPacket(sleepInfoPacket);
                    }
                }
            } else if (component2.key().equals("sleep.skipping_night")) {
                LevelEventGenericPacket sleepInfoPacket = new LevelEventGenericPacket();
                sleepInfoPacket.setType(LevelEvent.SLEEPING_PLAYERS);
                sleepInfoPacket.setTag(NbtMap.builder().putInt("ableToSleep", 1).putInt("overworldPlayerCount", 1).putInt("sleepingPlayerCount", 1).build());
                session.sendUpstreamPacket(sleepInfoPacket);
            }
        }
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        textPacket.setXuid(session.getAuthData().xuid());
        textPacket.setType(packet.isOverlay() ? TextPacket.Type.JUKEBOX_POPUP : TextPacket.Type.SYSTEM);
        textPacket.setNeedsTranslation(false);
        if (packet.isOverlay()) {
            textPacket.setMessage("\u00a7f" + MessageTranslator.convertMessage(packet.getContent(), session.locale()));
        } else {
            textPacket.setMessage(MessageTranslator.convertMessage(packet.getContent(), session.locale()));
        }
        if (session.isSentSpawnPacket()) {
            session.sendUpstreamPacket(textPacket);
        } else {
            session.getUpstream().queuePostStartGamePacket(textPacket);
        }
    }

    private static @Nullable Integer convertToInt(TranslationArgument translationArgument) {
        Object value = translationArgument.value();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)value;
            try {
                return Integer.parseInt(textComponent.content());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

