/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.util;

import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.geysermc.geyser.api.item.custom.v2.component.java.Consumable;
import org.geysermc.geyser.api.item.custom.v2.component.java.Equippable;
import org.geysermc.geyser.api.predicate.PredicateStrategy;
import org.geysermc.geyser.api.predicate.context.item.ChargedProjectile;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.definition.ItemDefinitionReaders;
import org.geysermc.geyser.registry.mappings.predicate.ItemConditionProperty;
import org.geysermc.geyser.registry.mappings.predicate.ItemMatchProperty;
import org.geysermc.geyser.registry.mappings.predicate.ItemRangeDispatchProperty;

@FunctionalInterface
public interface NodeReader<T> {
    public static final NodeReader<Integer> INT = node -> {
        double i = node.getAsDouble();
        if (i == (double)((int)i)) {
            return (int)i;
        }
        throw new InvalidCustomMappingsFileException("expected node to be an integer");
    };
    public static final NodeReader<Integer> NON_NEGATIVE_INT = INT.validate(i -> i >= 0, "integer must be non-negative");
    public static final NodeReader<Integer> POSITIVE_INT = INT.validate(i -> i > 0, "integer must be positive");
    public static final NodeReader<Double> DOUBLE = JsonPrimitive::getAsDouble;
    public static final NodeReader<Double> NON_NEGATIVE_DOUBLE = DOUBLE.validate(d -> d >= 0.0, "number must be non-negative");
    public static final NodeReader<Double> POSITIVE_DOUBLE = DOUBLE.validate(d -> d > 0.0, "number must be positive");
    public static final NodeReader<Float> FLOAT = DOUBLE.andThen(Double::floatValue);
    public static final NodeReader<Boolean> BOOLEAN = node -> {
        Number patt3554$temp;
        if (node.isString()) {
            String s = node.getAsString();
            if (s.equals("true")) {
                return true;
            }
            if (s.equals("false")) {
                return false;
            }
        } else if (node.isNumber() && (patt3554$temp = node.getAsNumber()) instanceof Integer) {
            Integer i = (Integer)patt3554$temp;
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return false;
            }
        } else if (node.isBoolean()) {
            return node.getAsBoolean();
        }
        throw new InvalidCustomMappingsFileException("expected node to be a boolean");
    };
    public static final NodeReader<String> STRING = JsonPrimitive::getAsString;
    public static final NodeReader<String> NON_EMPTY_STRING = STRING.validate(s -> !s.isEmpty(), "string must not be empty");
    public static final NodeReader<Identifier> IDENTIFIER = NON_EMPTY_STRING.andThen(Identifier::of);
    public static final NodeReader<Identifier> GEYSER_IDENTIFIER = NON_EMPTY_STRING.validate(s -> !s.startsWith("minecraft:"), "namespace cannot be minecraft").andThen(Identifier::of).andThen(identifier -> {
        if (identifier.namespace().equals("minecraft")) {
            return Identifier.of("geyser_custom", identifier.path());
        }
        return identifier;
    });
    public static final NodeReader<Identifier> TAG = NON_EMPTY_STRING.andThen(s -> {
        if (s.startsWith("#")) {
            return s.replaceFirst("#", "");
        }
        throw new InvalidCustomMappingsFileException("tag must start with a #");
    }).andThen(Identifier::of);
    public static final NodeReader<CreativeCategory> CREATIVE_CATEGORY = NON_EMPTY_STRING.andThen(CreativeCategory::fromName).validate(Objects::nonNull, "unknown creative category");
    public static final NodeReader<ItemDefinitionReaders> ITEM_DEFINITION_READER = NodeReader.ofEnum(ItemDefinitionReaders.class);
    public static final NodeReader<PredicateStrategy> PREDICATE_STRATEGY = NodeReader.ofEnum(PredicateStrategy.class);
    public static final NodeReader<ItemConditionProperty> ITEM_CONDITION_PROPERTY = NodeReader.ofEnum(ItemConditionProperty.class);
    public static final NodeReader<ItemMatchProperty> ITEM_MATCH_PROPERTY = NodeReader.ofEnum(ItemMatchProperty.class);
    public static final NodeReader<ItemRangeDispatchProperty> ITEM_RANGE_DISPATCH_PROPERTY = NodeReader.ofEnum(ItemRangeDispatchProperty.class);
    public static final NodeReader<ChargedProjectile.ChargeType> CHARGE_TYPE = NodeReader.ofEnum(ChargedProjectile.ChargeType.class);
    public static final NodeReader<Consumable.Animation> CONSUMABLE_ANIMATION = NodeReader.ofEnum(Consumable.Animation.class);
    public static final NodeReader<Equippable.EquipmentSlot> EQUIPMENT_SLOT = NodeReader.ofEnum(Equippable.EquipmentSlot.class);

    public static <E extends Enum<E>> NodeReader<E> ofEnum(Class<E> clazz) {
        return NON_EMPTY_STRING.andThen(String::toUpperCase).andThen(s -> {
            try {
                return Enum.valueOf(clazz, s);
            }
            catch (IllegalArgumentException exception) {
                throw new InvalidCustomMappingsFileException("unknown element, must be one of [" + String.join((CharSequence)", ", (CharSequence[])Arrays.stream((Enum[])clazz.getEnumConstants()).map(Enum::toString).toArray(String[]::new)).toLowerCase() + "]");
            }
        });
    }

    public static <T> NodeReader<T> ofMap(Map<String, T> map) {
        return NON_EMPTY_STRING.andThen(String::toLowerCase).andThen(s -> {
            Object value = map.get(s);
            if (value == null) {
                throw new InvalidCustomMappingsFileException("unknown element, must be one of [" + String.join((CharSequence)", ", map.keySet()).toLowerCase() + "]");
            }
            return value;
        });
    }

    public static NodeReader<Integer> boundedInt(int min, int max) {
        return INT.validate(i -> i >= min && i <= max, "integer must be in range [" + min + ", " + max + "]");
    }

    public static NodeReader<Double> boundedDouble(double min, double max) {
        return DOUBLE.validate(d -> d >= min && d <= max, "number must be in range [" + min + ", " + max + "]");
    }

    public T read(JsonPrimitive var1) throws InvalidCustomMappingsFileException;

    default public T read(JsonPrimitive node, String task, String ... context) throws InvalidCustomMappingsFileException {
        try {
            return this.read(node);
        }
        catch (Exception exception) {
            throw new InvalidCustomMappingsFileException(task, exception.getMessage() + " (node was " + node.toString() + ")", context);
        }
    }

    default public <V> NodeReader<V> andThen(After<T, V> after) {
        return node -> after.apply(this.read(node));
    }

    default public NodeReader<T> validate(Predicate<T> validator, String error) {
        return this.andThen(v -> {
            if (!validator.test(v)) {
                throw new InvalidCustomMappingsFileException(error);
            }
            return v;
        });
    }

    @FunctionalInterface
    public static interface After<V, T> {
        public T apply(V var1) throws InvalidCustomMappingsFileException;
    }
}

