/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.components;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.component.java.ItemDataComponents;
import org.geysermc.geyser.api.item.custom.v2.component.java.PiercingWeapon;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.custom.impl.PiercingWeaponImpl;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.components.DataComponentReader;
import org.geysermc.geyser.registry.mappings.components.readers.AttackRangeReader;
import org.geysermc.geyser.registry.mappings.components.readers.BooleanComponentReader;
import org.geysermc.geyser.registry.mappings.components.readers.ConsumableReader;
import org.geysermc.geyser.registry.mappings.components.readers.EnchantableReader;
import org.geysermc.geyser.registry.mappings.components.readers.EquippableReader;
import org.geysermc.geyser.registry.mappings.components.readers.FoodPropertiesReader;
import org.geysermc.geyser.registry.mappings.components.readers.IntComponentReader;
import org.geysermc.geyser.registry.mappings.components.readers.KineticWeaponReader;
import org.geysermc.geyser.registry.mappings.components.readers.RepairableReader;
import org.geysermc.geyser.registry.mappings.components.readers.SwingAnimationReader;
import org.geysermc.geyser.registry.mappings.components.readers.ToolPropertiesReader;
import org.geysermc.geyser.registry.mappings.components.readers.UnitReader;
import org.geysermc.geyser.registry.mappings.components.readers.UseCooldownReader;
import org.geysermc.geyser.registry.mappings.components.readers.UseEffectsReader;
import org.geysermc.geyser.util.MinecraftKey;

public class DataComponentReaders {
    private static final Map<Key, DataComponentReader<?>> READERS = new HashMap();

    public static void readDataComponent(CustomItemDefinition.Builder builder, String key, @NonNull JsonElement element, String baseContext) throws InvalidCustomMappingsFileException {
        if (key.startsWith("!")) {
            builder.removeComponent(Identifier.of(key.substring(1)));
            return;
        }
        DataComponentReader<?> reader = READERS.get(MinecraftKey.key(key));
        if (reader == null) {
            throw new InvalidCustomMappingsFileException("reading data components", "unknown data component " + key, baseContext);
        }
        reader.read(builder, element, "component " + key, baseContext);
    }

    private static void register(DataComponentReader<?> reader) {
        Key key = MinecraftKey.identifierToKey(reader.type().identifier());
        if (READERS.containsKey(key)) {
            throw new IllegalStateException("Duplicate component reader for component: " + String.valueOf(reader.type().identifier()));
        }
        READERS.put(key, reader);
    }

    static {
        DataComponentReaders.register(new ConsumableReader());
        DataComponentReaders.register(new EquippableReader());
        DataComponentReaders.register(new FoodPropertiesReader());
        DataComponentReaders.register(new IntComponentReader(ItemDataComponents.MAX_DAMAGE, 0));
        DataComponentReaders.register(new IntComponentReader(ItemDataComponents.MAX_STACK_SIZE, 1, 99));
        DataComponentReaders.register(new UseCooldownReader());
        DataComponentReaders.register(new EnchantableReader());
        DataComponentReaders.register(new ToolPropertiesReader());
        DataComponentReaders.register(new RepairableReader());
        DataComponentReaders.register(new BooleanComponentReader(ItemDataComponents.ENCHANTMENT_GLINT_OVERRIDE));
        DataComponentReaders.register(new AttackRangeReader());
        DataComponentReaders.register(new KineticWeaponReader());
        DataComponentReaders.register(new UnitReader<PiercingWeapon>(ItemDataComponents.PIERCING_WEAPON, PiercingWeaponImpl.INSTANCE));
        DataComponentReaders.register(new SwingAnimationReader());
        DataComponentReaders.register(new UseEffectsReader());
    }
}

