/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.velocity;

import com.google.gson.annotations.JsonAdapter;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.text.AsteriskSerializer;

public class GeyserVelocityDumpInfo
extends BootstrapDumpInfo {
    private final String platformName;
    private final String platformVersion;
    private final String platformVendor;
    private final boolean onlineMode;
    @JsonAdapter(value=AsteriskSerializer.class)
    private final String serverIP;
    private final int serverPort;
    private final List<BootstrapDumpInfo.PluginInfo> plugins;

    GeyserVelocityDumpInfo(ProxyServer proxy) {
        this.platformName = proxy.getVersion().getName();
        this.platformVersion = proxy.getVersion().getVersion();
        this.platformVendor = proxy.getVersion().getVendor();
        this.onlineMode = proxy.getConfiguration().isOnlineMode();
        this.serverIP = proxy.getBoundAddress().getHostString();
        this.serverPort = proxy.getBoundAddress().getPort();
        this.plugins = new ArrayList<BootstrapDumpInfo.PluginInfo>();
        for (PluginContainer plugin : proxy.getPluginManager().getPlugins()) {
            String pluginClass = plugin.getInstance().map(pl -> pl.getClass().getName()).orElse("unknown");
            this.plugins.add(new BootstrapDumpInfo.PluginInfo(true, plugin.getDescription().getName().orElse(null), plugin.getDescription().getVersion().orElse(null), pluginClass, plugin.getDescription().getAuthors()));
        }
    }

    @Generated
    public String getPlatformName() {
        return this.platformName;
    }

    @Generated
    public String getPlatformVersion() {
        return this.platformVersion;
    }

    @Generated
    public String getPlatformVendor() {
        return this.platformVendor;
    }

    @Generated
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Generated
    public String getServerIP() {
        return this.serverIP;
    }

    @Generated
    public int getServerPort() {
        return this.serverPort;
    }

    @Generated
    public List<BootstrapDumpInfo.PluginInfo> getPlugins() {
        return this.plugins;
    }
}

