/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import lombok.Generated;

public class BedrockDimension {
    public static final int OVERWORLD_ID = 0;
    public static final int DEFAULT_NETHER_ID = 1;
    public static final int END_ID = 2;
    public static int BEDROCK_NETHER_ID = 1;
    public static final BedrockDimension OVERWORLD = new BedrockDimension(-64, 384, true, 0);
    public static final BedrockDimension THE_NETHER = new BedrockDimension(0, 128, false, -1){

        @Override
        public int bedrockId() {
            return BEDROCK_NETHER_ID;
        }
    };
    public static final BedrockDimension THE_END = new BedrockDimension(0, 256, true, 2);
    public static final String NETHER_IDENTIFIER = "minecraft:the_nether";
    private final int minY;
    private final int height;
    private final boolean doUpperHeightWarn;
    private final int bedrockId;

    public BedrockDimension(int minY, int height, boolean doUpperHeightWarn, int bedrockId) {
        this.minY = minY;
        this.height = height;
        this.doUpperHeightWarn = doUpperHeightWarn;
        this.bedrockId = bedrockId;
    }

    public static void changeBedrockNetherId(boolean isAboveNetherBedrockBuilding) {
        BEDROCK_NETHER_ID = isAboveNetherBedrockBuilding ? 2 : 1;
    }

    public static boolean isCustomBedrockNetherId() {
        return BEDROCK_NETHER_ID == 2;
    }

    public int maxY() {
        return this.minY + this.height;
    }

    public int minY() {
        return this.minY;
    }

    public int height() {
        return this.height;
    }

    public boolean doUpperHeightWarn() {
        return this.doUpperHeightWarn;
    }

    public int bedrockId() {
        return this.bedrockId;
    }

    @Generated
    public String toString() {
        return "BedrockDimension(minY=" + this.minY + ", height=" + this.height + ", doUpperHeightWarn=" + this.doUpperHeightWarn + ", bedrockId=" + this.bedrockId + ")";
    }
}

