/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item;

import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.item.custom.CustomRenderOffsets;
import org.geysermc.geyser.api.item.custom.NonVanillaCustomItemData;
import org.geysermc.geyser.api.item.custom.v2.CustomItemBedrockOptions;
import org.geysermc.geyser.api.item.custom.v2.NonVanillaCustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.component.DataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.BlockPlacer;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.Chargeable;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.GeyserDataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.java.Consumable;
import org.geysermc.geyser.api.item.custom.v2.component.java.Equippable;
import org.geysermc.geyser.api.item.custom.v2.component.java.FoodProperties;
import org.geysermc.geyser.api.item.custom.v2.component.java.ItemDataComponents;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.GeyserCustomItemData;

@Deprecated
public final class GeyserNonVanillaCustomItemData
extends GeyserCustomItemData
implements NonVanillaCustomItemData {
    private final String identifier;
    private final int javaId;
    private final int stackSize;
    private final int maxDamage;
    private final int attackDamage;
    private final String toolType;
    private final String toolTier;
    private final String armorType;
    private final int protectionValue;
    private final String translationString;
    private final Set<String> repairMaterials;
    private final boolean isHat;
    private final boolean isFoil;
    private final boolean isTool;
    private final boolean isEdible;
    private final boolean canAlwaysEat;
    private final boolean isChargeable;
    private final String block;

    public GeyserNonVanillaCustomItemData(Builder builder) {
        super(builder.name, builder.customItemOptions, builder.displayName, builder.icon, builder.allowOffhand, builder.displayHandheld, builder.creativeCategory, builder.creativeGroup, builder.textureSize, builder.renderOffsets, builder.tags);
        this.identifier = builder.identifier;
        this.javaId = builder.javaId;
        this.stackSize = builder.stackSize;
        this.maxDamage = builder.maxDamage;
        this.attackDamage = builder.attackDamage;
        this.toolType = builder.toolType;
        this.toolTier = builder.toolTier;
        this.armorType = builder.armorType;
        this.protectionValue = builder.protectionValue;
        this.translationString = builder.translationString;
        this.repairMaterials = builder.repairMaterials;
        this.isHat = builder.hat;
        this.isFoil = builder.foil;
        this.isTool = builder.tool;
        this.isEdible = builder.edible;
        this.canAlwaysEat = builder.canAlwaysEat;
        this.isChargeable = builder.chargeable;
        this.block = builder.block;
    }

    @Override
    public @NonNull String identifier() {
        return this.identifier;
    }

    @Override
    public int javaId() {
        return this.javaId;
    }

    @Override
    public int stackSize() {
        return this.stackSize;
    }

    @Override
    public int maxDamage() {
        return this.maxDamage;
    }

    @Override
    public int attackDamage() {
        return this.attackDamage;
    }

    @Override
    public String toolType() {
        return this.toolType;
    }

    @Override
    public String toolTier() {
        return this.toolTier;
    }

    @Override
    public @Nullable String armorType() {
        return this.armorType;
    }

    @Override
    public int protectionValue() {
        return this.protectionValue;
    }

    @Override
    public String translationString() {
        return this.translationString;
    }

    @Override
    public Set<String> repairMaterials() {
        return this.repairMaterials;
    }

    @Override
    public boolean isHat() {
        return this.isHat;
    }

    @Override
    public boolean isFoil() {
        return this.isFoil;
    }

    @Override
    public boolean isEdible() {
        return this.isEdible;
    }

    @Override
    public boolean canAlwaysEat() {
        return this.canAlwaysEat;
    }

    @Override
    public boolean isChargeable() {
        return this.isChargeable;
    }

    @Override
    public String block() {
        return this.block;
    }

    public NonVanillaCustomItemDefinition.Builder toDefinition() {
        NonVanillaCustomItemDefinition.Builder definition = NonVanillaCustomItemDefinition.builder(Identifier.of(this.identifier()), this.javaId()).displayName(this.displayName()).bedrockOptions(CustomItemBedrockOptions.builder().icon(this.icon()).allowOffhand(this.allowOffhand()).displayHandheld(this.displayHandheld()).creativeCategory(this.creativeCategory().isEmpty() ? CreativeCategory.NONE : CreativeCategory.values()[this.creativeCategory().getAsInt()]).creativeGroup(this.creativeGroup()).tags(this.tags().stream().map(Identifier::of).collect(Collectors.toSet())).protectionValue(this.protectionValue())).component((DataComponent)ItemDataComponents.MAX_STACK_SIZE, (Object)this.stackSize()).component((DataComponent)ItemDataComponents.MAX_DAMAGE, (Object)this.maxDamage()).component((DataComponent)GeyserDataComponent.ATTACK_DAMAGE, (Object)this.attackDamage()).translationString(this.translationString());
        if (this.isHat()) {
            definition.component((DataComponent)ItemDataComponents.EQUIPPABLE, Equippable.builder().slot(Equippable.EquipmentSlot.HEAD).build());
        } else if (this.armorType() != null) {
            switch (this.armorType()) {
                case "helmet": {
                    definition.component(ItemDataComponents.EQUIPPABLE, Equippable.builder().slot(Equippable.EquipmentSlot.HEAD));
                    break;
                }
                case "chestplate": {
                    definition.component(ItemDataComponents.EQUIPPABLE, Equippable.builder().slot(Equippable.EquipmentSlot.CHEST));
                    break;
                }
                case "leggings": {
                    definition.component(ItemDataComponents.EQUIPPABLE, Equippable.builder().slot(Equippable.EquipmentSlot.LEGS));
                    break;
                }
                case "boots": {
                    definition.component((DataComponent)ItemDataComponents.EQUIPPABLE, Equippable.of(Equippable.EquipmentSlot.FEET));
                }
            }
        }
        if (this.isEdible()) {
            definition.component(ItemDataComponents.CONSUMABLE, Consumable.builder().consumeSeconds(1.6f).animation(Consumable.Animation.EAT));
            if (this.canAlwaysEat()) {
                definition.component(ItemDataComponents.FOOD, FoodProperties.builder().canAlwaysEat(true));
            }
        }
        if (this.isChargeable() && this.toolType() != null) {
            if (this.toolType().equals("bow")) {
                definition.component(GeyserDataComponent.CHARGEABLE, Chargeable.builder().maxDrawDuration(1.0f).chargeOnDraw(true).ammunition(Identifier.of("arrow")));
            } else {
                definition.component(GeyserDataComponent.CHARGEABLE, Chargeable.builder().ammunition(Identifier.of("arrow")));
            }
        }
        if (this.block() != null) {
            definition.component(GeyserDataComponent.BLOCK_PLACER, BlockPlacer.builder().block(Identifier.of(this.block())));
        }
        return definition;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeyserNonVanillaCustomItemData)) {
            return false;
        }
        GeyserNonVanillaCustomItemData other = (GeyserNonVanillaCustomItemData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.javaId != other.javaId) {
            return false;
        }
        if (this.stackSize != other.stackSize) {
            return false;
        }
        if (this.maxDamage != other.maxDamage) {
            return false;
        }
        if (this.attackDamage != other.attackDamage) {
            return false;
        }
        if (this.protectionValue != other.protectionValue) {
            return false;
        }
        if (this.isHat() != other.isHat()) {
            return false;
        }
        if (this.isFoil() != other.isFoil()) {
            return false;
        }
        if (this.isTool != other.isTool) {
            return false;
        }
        if (this.isEdible() != other.isEdible()) {
            return false;
        }
        if (this.canAlwaysEat != other.canAlwaysEat) {
            return false;
        }
        if (this.isChargeable() != other.isChargeable()) {
            return false;
        }
        String this$identifier = this.identifier;
        String other$identifier = other.identifier;
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$toolType = this.toolType;
        String other$toolType = other.toolType;
        if (this$toolType == null ? other$toolType != null : !this$toolType.equals(other$toolType)) {
            return false;
        }
        String this$toolTier = this.toolTier;
        String other$toolTier = other.toolTier;
        if (this$toolTier == null ? other$toolTier != null : !this$toolTier.equals(other$toolTier)) {
            return false;
        }
        String this$armorType = this.armorType;
        String other$armorType = other.armorType;
        if (this$armorType == null ? other$armorType != null : !this$armorType.equals(other$armorType)) {
            return false;
        }
        String this$translationString = this.translationString;
        String other$translationString = other.translationString;
        if (this$translationString == null ? other$translationString != null : !this$translationString.equals(other$translationString)) {
            return false;
        }
        Set<String> this$repairMaterials = this.repairMaterials;
        Set<String> other$repairMaterials = other.repairMaterials;
        if (this$repairMaterials == null ? other$repairMaterials != null : !((Object)this$repairMaterials).equals(other$repairMaterials)) {
            return false;
        }
        String this$block = this.block;
        String other$block = other.block;
        return !(this$block == null ? other$block != null : !this$block.equals(other$block));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeyserNonVanillaCustomItemData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.javaId;
        result = result * 59 + this.stackSize;
        result = result * 59 + this.maxDamage;
        result = result * 59 + this.attackDamage;
        result = result * 59 + this.protectionValue;
        result = result * 59 + (this.isHat() ? 79 : 97);
        result = result * 59 + (this.isFoil() ? 79 : 97);
        result = result * 59 + (this.isTool ? 79 : 97);
        result = result * 59 + (this.isEdible() ? 79 : 97);
        result = result * 59 + (this.canAlwaysEat ? 79 : 97);
        result = result * 59 + (this.isChargeable() ? 79 : 97);
        String $identifier = this.identifier;
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $toolType = this.toolType;
        result = result * 59 + ($toolType == null ? 43 : $toolType.hashCode());
        String $toolTier = this.toolTier;
        result = result * 59 + ($toolTier == null ? 43 : $toolTier.hashCode());
        String $armorType = this.armorType;
        result = result * 59 + ($armorType == null ? 43 : $armorType.hashCode());
        String $translationString = this.translationString;
        result = result * 59 + ($translationString == null ? 43 : $translationString.hashCode());
        Set<String> $repairMaterials = this.repairMaterials;
        result = result * 59 + ($repairMaterials == null ? 43 : ((Object)$repairMaterials).hashCode());
        String $block = this.block;
        result = result * 59 + ($block == null ? 43 : $block.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "GeyserNonVanillaCustomItemData(identifier=" + this.identifier + ", javaId=" + this.javaId + ", stackSize=" + this.stackSize + ", maxDamage=" + this.maxDamage + ", attackDamage=" + this.attackDamage + ", toolType=" + this.toolType + ", toolTier=" + this.toolTier + ", armorType=" + this.armorType + ", protectionValue=" + this.protectionValue + ", translationString=" + this.translationString + ", repairMaterials=" + String.valueOf(this.repairMaterials) + ", isHat=" + this.isHat() + ", isFoil=" + this.isFoil() + ", isTool=" + this.isTool + ", isEdible=" + this.isEdible() + ", canAlwaysEat=" + this.canAlwaysEat + ", isChargeable=" + this.isChargeable() + ", block=" + this.block + ")";
    }

    public static class Builder
    extends GeyserCustomItemData.Builder
    implements NonVanillaCustomItemData.Builder {
        private String identifier = null;
        private int javaId = -1;
        private int stackSize = 64;
        private int maxDamage = 0;
        private int attackDamage = 0;
        private String toolType = null;
        private String toolTier = null;
        private String armorType = null;
        private int protectionValue = 0;
        private String translationString;
        private Set<String> repairMaterials;
        private boolean hat = false;
        private boolean foil = false;
        private boolean tool = false;
        private boolean edible = false;
        private boolean canAlwaysEat = false;
        private boolean chargeable = false;
        private String block = null;

        @Override
        public Builder name(@NonNull String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder customItemOptions(@NonNull CustomItemOptions customItemOptions) {
            return this;
        }

        @Override
        public Builder allowOffhand(boolean allowOffhand) {
            return (Builder)super.allowOffhand(allowOffhand);
        }

        @Override
        public Builder displayHandheld(boolean displayHandheld) {
            return (Builder)super.displayHandheld(displayHandheld);
        }

        @Override
        public Builder displayName(@NonNull String displayName) {
            return (Builder)super.displayName(displayName);
        }

        @Override
        public Builder icon(@NonNull String icon) {
            return (Builder)super.icon(icon);
        }

        @Override
        public Builder textureSize(int textureSize) {
            return (Builder)super.textureSize(textureSize);
        }

        @Override
        public Builder renderOffsets(CustomRenderOffsets renderOffsets) {
            return (Builder)super.renderOffsets(renderOffsets);
        }

        @Override
        public Builder tags(@Nullable Set<String> tags) {
            return (Builder)super.tags((Set)tags);
        }

        @Override
        public Builder identifier(@NonNull String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder javaId(int javaId) {
            this.javaId = javaId;
            return this;
        }

        @Override
        public Builder stackSize(int stackSize) {
            this.stackSize = stackSize;
            return this;
        }

        @Override
        public Builder maxDamage(int maxDamage) {
            this.maxDamage = maxDamage;
            return this;
        }

        @Override
        public NonVanillaCustomItemData.Builder attackDamage(int attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        @Override
        public Builder toolType(@Nullable String toolType) {
            this.toolType = toolType;
            return this;
        }

        @Override
        public Builder toolTier(@Nullable String toolTier) {
            this.toolTier = toolTier;
            return this;
        }

        @Override
        public Builder armorType(@Nullable String armorType) {
            this.armorType = armorType;
            return this;
        }

        @Override
        public Builder protectionValue(int protectionValue) {
            this.protectionValue = protectionValue;
            return this;
        }

        @Override
        public Builder translationString(@Nullable String translationString) {
            this.translationString = translationString;
            return this;
        }

        @Override
        public Builder repairMaterials(@Nullable Set<String> repairMaterials) {
            this.repairMaterials = repairMaterials;
            return this;
        }

        @Override
        public Builder creativeCategory(int creativeCategory) {
            return (Builder)super.creativeCategory(creativeCategory);
        }

        @Override
        public Builder creativeGroup(@Nullable String creativeGroup) {
            return (Builder)super.creativeGroup(creativeGroup);
        }

        @Override
        public Builder hat(boolean isHat) {
            this.hat = isHat;
            return this;
        }

        @Override
        public Builder foil(boolean isFoil) {
            this.foil = isFoil;
            return this;
        }

        @Override
        public Builder edible(boolean isEdible) {
            this.edible = isEdible;
            return this;
        }

        @Override
        public Builder canAlwaysEat(boolean canAlwaysEat) {
            this.canAlwaysEat = canAlwaysEat;
            return this;
        }

        @Override
        public Builder chargeable(boolean isChargeable) {
            this.chargeable = isChargeable;
            return this;
        }

        @Override
        public Builder block(String block) {
            this.block = block;
            return this;
        }

        @Override
        public NonVanillaCustomItemData build() {
            if (this.identifier == null || this.javaId == -1) {
                throw new IllegalArgumentException("Identifier and javaId must be set");
            }
            super.customItemOptions(CustomItemOptions.builder().build());
            super.build();
            return new GeyserNonVanillaCustomItemData(this);
        }
    }
}

