/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.packet.geyserbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPacket;
import org.geysermc.erosion.packet.geyserbound.GeyserboundPacketHandler;

public final class GeyserboundBatchBlockIdPacket
implements GeyserboundPacket {
    private final int[] blocks;

    public GeyserboundBatchBlockIdPacket(int[] blocks) {
        this.blocks = blocks;
    }

    public GeyserboundBatchBlockIdPacket(ByteBuf buf) {
        this.blocks = new int[VarInts.readUnsignedInt(buf)];
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = VarInts.readUnsignedInt(buf);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        VarInts.writeUnsignedInt(buf, this.blocks.length);
        for (int block : this.blocks) {
            VarInts.writeUnsignedInt(buf, block);
        }
    }

    @Override
    public void handle(GeyserboundPacketHandler packetHandler) {
        packetHandler.handleBatchBlockId(this);
    }

    public int[] getBlocks() {
        return this.blocks;
    }

    public String toString() {
        return "GeyserboundBatchBlockIdPacket{blocks=" + Arrays.toString(this.blocks) + "}";
    }
}

