/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import java.util.List;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryActionData;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.InventoryTransactionType;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.ItemUseTransaction;
import org.cloudburstmc.protocol.bedrock.data.inventory.transaction.LegacySetItemSlotData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class InventoryTransactionPacket
implements BedrockPacket {
    private int legacyRequestId;
    private final List<LegacySetItemSlotData> legacySlots = new ObjectArrayList<LegacySetItemSlotData>();
    private final List<InventoryActionData> actions = new ObjectArrayList<InventoryActionData>();
    private InventoryTransactionType transactionType;
    private int actionType;
    private long runtimeEntityId;
    private Vector3i blockPosition;
    private int blockFace;
    private int hotbarSlot;
    private ItemData itemInHand;
    private Vector3f playerPosition;
    private Vector3f clickPosition;
    private Vector3f headPosition;
    @Deprecated
    private boolean usingNetIds;
    private BlockDefinition blockDefinition;
    private ItemUseTransaction.TriggerType triggerType;
    private ItemUseTransaction.PredictedResult clientInteractPrediction;

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.INVENTORY_TRANSACTION;
    }

    @Override
    public InventoryTransactionPacket clone() {
        try {
            return (InventoryTransactionPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int getLegacyRequestId() {
        return this.legacyRequestId;
    }

    public List<LegacySetItemSlotData> getLegacySlots() {
        return this.legacySlots;
    }

    public List<InventoryActionData> getActions() {
        return this.actions;
    }

    public InventoryTransactionType getTransactionType() {
        return this.transactionType;
    }

    public int getActionType() {
        return this.actionType;
    }

    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public int getBlockFace() {
        return this.blockFace;
    }

    public int getHotbarSlot() {
        return this.hotbarSlot;
    }

    public ItemData getItemInHand() {
        return this.itemInHand;
    }

    public Vector3f getPlayerPosition() {
        return this.playerPosition;
    }

    public Vector3f getClickPosition() {
        return this.clickPosition;
    }

    public Vector3f getHeadPosition() {
        return this.headPosition;
    }

    @Deprecated
    public boolean isUsingNetIds() {
        return this.usingNetIds;
    }

    public BlockDefinition getBlockDefinition() {
        return this.blockDefinition;
    }

    public ItemUseTransaction.TriggerType getTriggerType() {
        return this.triggerType;
    }

    public ItemUseTransaction.PredictedResult getClientInteractPrediction() {
        return this.clientInteractPrediction;
    }

    public void setLegacyRequestId(int legacyRequestId) {
        this.legacyRequestId = legacyRequestId;
    }

    public void setTransactionType(InventoryTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public void setBlockFace(int blockFace) {
        this.blockFace = blockFace;
    }

    public void setHotbarSlot(int hotbarSlot) {
        this.hotbarSlot = hotbarSlot;
    }

    public void setItemInHand(ItemData itemInHand) {
        this.itemInHand = itemInHand;
    }

    public void setPlayerPosition(Vector3f playerPosition) {
        this.playerPosition = playerPosition;
    }

    public void setClickPosition(Vector3f clickPosition) {
        this.clickPosition = clickPosition;
    }

    public void setHeadPosition(Vector3f headPosition) {
        this.headPosition = headPosition;
    }

    @Deprecated
    public void setUsingNetIds(boolean usingNetIds) {
        this.usingNetIds = usingNetIds;
    }

    public void setBlockDefinition(BlockDefinition blockDefinition) {
        this.blockDefinition = blockDefinition;
    }

    public void setTriggerType(ItemUseTransaction.TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setClientInteractPrediction(ItemUseTransaction.PredictedResult clientInteractPrediction) {
        this.clientInteractPrediction = clientInteractPrediction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryTransactionPacket)) {
            return false;
        }
        InventoryTransactionPacket other = (InventoryTransactionPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.legacyRequestId != other.legacyRequestId) {
            return false;
        }
        if (this.actionType != other.actionType) {
            return false;
        }
        if (this.runtimeEntityId != other.runtimeEntityId) {
            return false;
        }
        if (this.blockFace != other.blockFace) {
            return false;
        }
        if (this.hotbarSlot != other.hotbarSlot) {
            return false;
        }
        if (this.usingNetIds != other.usingNetIds) {
            return false;
        }
        List<LegacySetItemSlotData> this$legacySlots = this.legacySlots;
        List<LegacySetItemSlotData> other$legacySlots = other.legacySlots;
        if (this$legacySlots == null ? other$legacySlots != null : !((Object)this$legacySlots).equals(other$legacySlots)) {
            return false;
        }
        List<InventoryActionData> this$actions = this.actions;
        List<InventoryActionData> other$actions = other.actions;
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        InventoryTransactionType this$transactionType = this.transactionType;
        InventoryTransactionType other$transactionType = other.transactionType;
        if (this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType)) {
            return false;
        }
        Vector3i this$blockPosition = this.blockPosition;
        Vector3i other$blockPosition = other.blockPosition;
        if (this$blockPosition == null ? other$blockPosition != null : !this$blockPosition.equals(other$blockPosition)) {
            return false;
        }
        ItemData this$itemInHand = this.itemInHand;
        ItemData other$itemInHand = other.itemInHand;
        if (this$itemInHand == null ? other$itemInHand != null : !this$itemInHand.equals(other$itemInHand)) {
            return false;
        }
        Vector3f this$playerPosition = this.playerPosition;
        Vector3f other$playerPosition = other.playerPosition;
        if (this$playerPosition == null ? other$playerPosition != null : !this$playerPosition.equals(other$playerPosition)) {
            return false;
        }
        Vector3f this$clickPosition = this.clickPosition;
        Vector3f other$clickPosition = other.clickPosition;
        if (this$clickPosition == null ? other$clickPosition != null : !this$clickPosition.equals(other$clickPosition)) {
            return false;
        }
        Vector3f this$headPosition = this.headPosition;
        Vector3f other$headPosition = other.headPosition;
        if (this$headPosition == null ? other$headPosition != null : !this$headPosition.equals(other$headPosition)) {
            return false;
        }
        BlockDefinition this$blockDefinition = this.blockDefinition;
        BlockDefinition other$blockDefinition = other.blockDefinition;
        if (this$blockDefinition == null ? other$blockDefinition != null : !this$blockDefinition.equals(other$blockDefinition)) {
            return false;
        }
        ItemUseTransaction.TriggerType this$triggerType = this.triggerType;
        ItemUseTransaction.TriggerType other$triggerType = other.triggerType;
        if (this$triggerType == null ? other$triggerType != null : !((Object)((Object)this$triggerType)).equals((Object)other$triggerType)) {
            return false;
        }
        ItemUseTransaction.PredictedResult this$clientInteractPrediction = this.clientInteractPrediction;
        ItemUseTransaction.PredictedResult other$clientInteractPrediction = other.clientInteractPrediction;
        return !(this$clientInteractPrediction == null ? other$clientInteractPrediction != null : !((Object)((Object)this$clientInteractPrediction)).equals((Object)other$clientInteractPrediction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InventoryTransactionPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.legacyRequestId;
        result = result * 59 + this.actionType;
        long $runtimeEntityId = this.runtimeEntityId;
        result = result * 59 + (int)($runtimeEntityId >>> 32 ^ $runtimeEntityId);
        result = result * 59 + this.blockFace;
        result = result * 59 + this.hotbarSlot;
        result = result * 59 + (this.usingNetIds ? 79 : 97);
        List<LegacySetItemSlotData> $legacySlots = this.legacySlots;
        result = result * 59 + ($legacySlots == null ? 43 : ((Object)$legacySlots).hashCode());
        List<InventoryActionData> $actions = this.actions;
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        InventoryTransactionType $transactionType = this.transactionType;
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        Vector3i $blockPosition = this.blockPosition;
        result = result * 59 + ($blockPosition == null ? 43 : $blockPosition.hashCode());
        ItemData $itemInHand = this.itemInHand;
        result = result * 59 + ($itemInHand == null ? 43 : $itemInHand.hashCode());
        Vector3f $playerPosition = this.playerPosition;
        result = result * 59 + ($playerPosition == null ? 43 : $playerPosition.hashCode());
        Vector3f $clickPosition = this.clickPosition;
        result = result * 59 + ($clickPosition == null ? 43 : $clickPosition.hashCode());
        Vector3f $headPosition = this.headPosition;
        result = result * 59 + ($headPosition == null ? 43 : $headPosition.hashCode());
        BlockDefinition $blockDefinition = this.blockDefinition;
        result = result * 59 + ($blockDefinition == null ? 43 : $blockDefinition.hashCode());
        ItemUseTransaction.TriggerType $triggerType = this.triggerType;
        result = result * 59 + ($triggerType == null ? 43 : ((Object)((Object)$triggerType)).hashCode());
        ItemUseTransaction.PredictedResult $clientInteractPrediction = this.clientInteractPrediction;
        result = result * 59 + ($clientInteractPrediction == null ? 43 : ((Object)((Object)$clientInteractPrediction)).hashCode());
        return result;
    }

    public String toString() {
        return "InventoryTransactionPacket(legacyRequestId=" + this.legacyRequestId + ", legacySlots=" + this.legacySlots + ", actions=" + this.actions + ", transactionType=" + (Object)((Object)this.transactionType) + ", actionType=" + this.actionType + ", runtimeEntityId=" + this.runtimeEntityId + ", blockPosition=" + this.blockPosition + ", blockFace=" + this.blockFace + ", hotbarSlot=" + this.hotbarSlot + ", itemInHand=" + this.itemInHand + ", playerPosition=" + this.playerPosition + ", clickPosition=" + this.clickPosition + ", headPosition=" + this.headPosition + ", usingNetIds=" + this.usingNetIds + ", blockDefinition=" + this.blockDefinition + ", triggerType=" + (Object)((Object)this.triggerType) + ", clientInteractPrediction=" + (Object)((Object)this.clientInteractPrediction) + ")";
    }
}

