/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.executor.extra;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.net.CookieManager;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.net.ssl.TrustManager;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.executor.RequestExecutor;
import net.lenni0451.commons.httpclient.proxy.ProxyHandler;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.utils.IgnoringTrustManager;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ProxyProvider;

public class ReactorNettyExecutor
extends RequestExecutor {
    private static final byte[] EMPTY_BODY = new byte[0];

    public ReactorNettyExecutor(HttpClient client) {
        super(client);
    }

    @Override
    @Nonnull
    public HttpResponse execute(@Nonnull HttpRequest request) throws IOException {
        HttpContentRequest contentRequest;
        HttpClient.RequestSender requestSender;
        CookieManager cookieManager = this.getCookieManager(request);
        reactor.netty.http.client.HttpClient httpClient = this.buildClient(request, cookieManager);
        HttpClient.RequestSender responseReceiver = requestSender = (HttpClient.RequestSender)httpClient.request(HttpMethod.valueOf((String)request.getMethod())).uri(URLWrapper.of(request.getURL()).toURI());
        if (request instanceof HttpContentRequest && (contentRequest = (HttpContentRequest)request).getContent() != null) {
            responseReceiver = requestSender.send((Publisher)ByteBufFlux.fromInbound((Publisher)Flux.just((Object)contentRequest.getContent().getAsBytes())));
        }
        try {
            return (HttpResponse)responseReceiver.responseSingle((response, content) -> {
                try {
                    URL resourceURL = URLWrapper.ofURL(response.resourceUrl()).toURL();
                    Map<String, List<String>> responseHeaders = this.convertHeaders(response.responseHeaders());
                    this.updateCookies(cookieManager, resourceURL, responseHeaders);
                    return content.asByteArray().defaultIfEmpty((Object)EMPTY_BODY).map(bytes -> new HttpResponse(resourceURL, response.status().code(), (byte[])bytes, responseHeaders));
                }
                catch (Throwable t) {
                    return Mono.error((Throwable)t);
                }
            }).blockOptional().orElseThrow(() -> new IOException("Response is null"));
        }
        catch (Throwable t) {
            for (Throwable cause = t; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof IOException)) continue;
                throw (IOException)cause;
            }
            throw new IOException("Failed to execute request", t);
        }
    }

    private reactor.netty.http.client.HttpClient buildClient(HttpRequest request, CookieManager cookieManager) throws IOException {
        Map<String, List<String>> requestHeaders = this.getHeaders(request, cookieManager);
        reactor.netty.http.client.HttpClient httpClient = reactor.netty.http.client.HttpClient.create().responseTimeout(Duration.ofMillis(this.client.getReadTimeout())).followRedirect(this.isFollowRedirects(request)).headers(headers -> this.setHeaders(requestHeaders, (arg_0, arg_1) -> ((HttpHeaders)headers).set(arg_0, arg_1), (arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1)));
        if (this.isIgnoreInvalidSSL(request)) {
            httpClient = httpClient.secure(SslProvider.builder().sslContext(SslContextBuilder.forClient().trustManager((TrustManager)new IgnoringTrustManager()).build()).build());
        }
        if (this.client.getProxyHandler().isProxySet()) {
            ProxyHandler proxyHandler = this.client.getProxyHandler();
            httpClient = (reactor.netty.http.client.HttpClient)httpClient.proxy(typeSpec -> {
                ProxyProvider.AddressSpec addressSpec;
                switch (proxyHandler.getProxyType()) {
                    case HTTP: {
                        addressSpec = typeSpec.type(ProxyProvider.Proxy.HTTP);
                        break;
                    }
                    case SOCKS4: {
                        addressSpec = typeSpec.type(ProxyProvider.Proxy.SOCKS4);
                        break;
                    }
                    case SOCKS5: {
                        addressSpec = typeSpec.type(ProxyProvider.Proxy.SOCKS5);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported proxy type: " + (Object)((Object)proxyHandler.getProxyType()));
                    }
                }
                ProxyProvider.Builder builder = addressSpec.socketAddress(proxyHandler.getAddress());
                if (proxyHandler.getUsername() != null) {
                    builder.username(proxyHandler.getUsername());
                }
                if (proxyHandler.getPassword() != null) {
                    builder.password(s -> proxyHandler.getPassword());
                }
            });
        }
        return httpClient;
    }

    private Map<String, List<String>> convertHeaders(HttpHeaders headers) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : headers.entries()) {
            map.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).add((String)entry.getValue());
        }
        return map;
    }
}

