/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.metadata;

import io.netty.buffer.ByteBuf;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.LongEntityMetadata;

public class LongMetadataType
extends MetadataType<Long> {
    private final LongReader primitiveReader;
    private final LongWriter primitiveWriter;
    private final LongEntityMetadataFactory primitiveFactory;

    protected LongMetadataType(int id, LongReader reader, LongWriter writer, LongEntityMetadataFactory metadataFactory) {
        super(id, reader, writer, metadataFactory);
        this.primitiveReader = reader;
        this.primitiveWriter = writer;
        this.primitiveFactory = metadataFactory;
    }

    @Override
    public EntityMetadata<Long, LongMetadataType> readMetadata(ByteBuf input, int id) {
        return this.primitiveFactory.createPrimitive(id, this, this.primitiveReader.readPrimitive(input));
    }

    public void writeMetadataPrimitive(ByteBuf output, long value) {
        this.primitiveWriter.writePrimitive(output, value);
    }

    @FunctionalInterface
    public static interface LongReader
    extends MetadataType.Reader<Long> {
        public long readPrimitive(ByteBuf var1);

        @Override
        @Deprecated
        default public Long read(ByteBuf input) {
            return this.readPrimitive(input);
        }
    }

    @FunctionalInterface
    public static interface LongWriter
    extends MetadataType.Writer<Long> {
        public void writePrimitive(ByteBuf var1, long var2);

        @Override
        @Deprecated
        default public void write(ByteBuf output, Long value) {
            this.writePrimitive(output, value);
        }
    }

    @FunctionalInterface
    public static interface LongEntityMetadataFactory
    extends MetadataType.EntityMetadataFactory<Long> {
        public LongEntityMetadata createPrimitive(int var1, LongMetadataType var2, long var3);

        @Override
        @Deprecated
        default public EntityMetadata<Long, LongMetadataType> create(int id, MetadataType<Long> type, Long value) {
            throw new UnsupportedOperationException("Unsupported read method! Use primitive createPrimitive!");
        }
    }
}

