/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.chest;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.updater.ChestInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.BaseInventoryTranslator;

public abstract class ChestInventoryTranslator<Type extends Container>
extends BaseInventoryTranslator<Type> {
    private final InventoryUpdater updater;

    public ChestInventoryTranslator(int size, int paddedSize) {
        super(size);
        this.updater = new ChestInventoryUpdater(paddedSize);
    }

    @Override
    protected boolean shouldRejectItemPlace(GeyserSession session, Type container, ContainerSlotType bedrockSourceContainer, int javaSourceSlot, ContainerSlotType bedrockDestinationContainer, int javaDestinationSlot) {
        if (bedrockSourceContainer == this.slotType(container) && javaSourceSlot >= this.size) {
            return true;
        }
        return bedrockDestinationContainer == this.slotType(container) && javaDestinationSlot >= this.size;
    }

    @Override
    public boolean requiresOpeningDelay(GeyserSession session, Type container) {
        return !((Container)container).isUsingRealBlock();
    }

    @Override
    public void updateInventory(GeyserSession session, Type container) {
        this.updater.updateInventory(this, session, (Inventory)container);
    }

    @Override
    public void updateSlot(GeyserSession session, Type container, int slot) {
        this.updater.updateSlot(this, session, (Inventory)container, slot);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int javaSlot, Type inventory) {
        if (javaSlot < this.size) {
            return new BedrockContainerSlot(this.slotType(inventory), javaSlot);
        }
        return super.javaSlotToBedrockContainer(javaSlot, inventory);
    }

    protected ContainerSlotType slotType(Type type) {
        return ContainerSlotType.LEVEL_ENTITY;
    }
}

