/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.waypoint;

import java.awt.Color;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerLocationPacket;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.waypoint.AzimuthWaypoint;
import org.geysermc.geyser.session.cache.waypoint.ChunkWaypoint;
import org.geysermc.geyser.session.cache.waypoint.CoordinatesWaypoint;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.TrackedWaypoint;
import org.geysermc.mcprotocollib.protocol.data.game.level.waypoint.WaypointData;

public abstract class GeyserWaypoint {
    protected final GeyserSession session;
    private final Color color;
    private final UUID entityUuid;
    private long entityId;
    private boolean sendListPackets;
    protected Vector3f position = Vector3f.ZERO;
    private Vector3f lastSent = null;

    public GeyserWaypoint(GeyserSession session, Optional<UUID> uuid, OptionalLong entityId, Color color) {
        this.session = session;
        this.color = color;
        this.entityUuid = uuid.orElseGet(UUID::randomUUID);
        this.entityId = entityId.orElseGet(() -> session.getEntityCache().getNextEntityId().incrementAndGet());
        this.sendListPackets = entityId.isEmpty();
    }

    public void track(WaypointData data) {
        this.sendListPackets(PlayerListPacket.Action.ADD);
        this.update(data);
    }

    public void update(WaypointData data) {
        this.setData(data);
        this.sendLocationPacket(false);
    }

    public void untrack() {
        PlayerLocationPacket packet = new PlayerLocationPacket();
        packet.setType(PlayerLocationPacket.Type.HIDE);
        packet.setTargetEntityId(this.entityId);
        this.session.sendUpstreamPacket(packet);
        this.sendListPackets(PlayerListPacket.Action.REMOVE);
    }

    public void setPlayer(PlayerEntity entity) {
        if (this.sendListPackets) {
            this.untrack();
            this.entityId = entity.getGeyserId();
            this.sendListPackets = false;
            this.sendLocationPacket(true);
        } else if (entity == null) {
            this.entityId = this.session.getEntityCache().getNextEntityId().incrementAndGet();
            this.sendListPackets = true;
            this.sendListPackets(PlayerListPacket.Action.ADD);
            this.sendLocationPacket(true);
        }
    }

    protected void sendLocationPacket(boolean force) {
        if (force || this.lastSent == null || this.position.distanceSquared(this.lastSent) > 1.0f) {
            PlayerLocationPacket packet = new PlayerLocationPacket();
            packet.setType(PlayerLocationPacket.Type.COORDINATES);
            packet.setTargetEntityId(this.entityId);
            packet.setPosition(this.position);
            this.session.sendUpstreamPacket(packet);
            this.lastSent = this.position;
        }
    }

    private void sendListPackets(PlayerListPacket.Action action) {
        if (this.sendListPackets) {
            PlayerListPacket packet = new PlayerListPacket();
            packet.setAction(action);
            PlayerListPacket.Entry entry = new PlayerListPacket.Entry(this.entityUuid);
            entry.setEntityId(this.entityId);
            entry.setColor(this.color);
            packet.getEntries().add(entry);
            this.session.sendUpstreamPacket(packet);
        }
    }

    public abstract void setData(WaypointData var1);

    public static @Nullable GeyserWaypoint create(GeyserSession session, Optional<UUID> uuid, OptionalLong entityId, TrackedWaypoint waypoint) {
        Color color = GeyserWaypoint.getWaypointColor(waypoint);
        return switch (waypoint.type()) {
            default -> throw new IncompatibleClassChangeError();
            case TrackedWaypoint.Type.EMPTY -> null;
            case TrackedWaypoint.Type.VEC3I -> new CoordinatesWaypoint(session, uuid, entityId, color);
            case TrackedWaypoint.Type.CHUNK -> new ChunkWaypoint(session, uuid, entityId, color);
            case TrackedWaypoint.Type.AZIMUTH -> new AzimuthWaypoint(session, uuid, entityId, color);
        };
    }

    private static Color getWaypointColor(TrackedWaypoint waypoint) {
        return waypoint.icon().color().or(() -> Optional.ofNullable(waypoint.uuid()).map(UUID::hashCode)).or(() -> Optional.ofNullable(waypoint.id()).map(String::hashCode)).map(i -> new Color((int)(i & 0xFFFFFF))).orElseThrow();
    }

    @Generated
    public Color color() {
        return this.color;
    }
}

