/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.item.custom.v2.NonVanillaCustomItemDefinition;
import org.geysermc.geyser.item.components.resolvable.ResolvableComponent;
import org.geysermc.geyser.item.custom.ComponentConverters;
import org.geysermc.geyser.item.exception.InvalidItemComponentsException;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.GeyserMappingItem;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public record CustomItemContext(CustomItemDefinition definition, DataComponents components, List<ResolvableComponent<?>> resolvableComponents, Optional<GeyserMappingItem> vanillaMapping, int customItemId, int protocolVersion) {
    public static CustomItemContext createVanilla(Item javaItem, GeyserMappingItem vanillaMapping, CustomItemDefinition customItem, int customItemId, int protocolVersion) throws InvalidItemComponentsException {
        return new CustomItemContext(customItem, CustomItemContext.checkComponents(customItem, javaItem, resolvable -> {}), List.of(), Optional.of(vanillaMapping), customItemId, protocolVersion);
    }

    public static CustomItemContext createNonVanilla(NonVanillaCustomItemDefinition customItem, int customItemId, int protocolVersion) throws InvalidItemComponentsException {
        ArrayList resolvableComponents = new ArrayList();
        DataComponents components = CustomItemContext.checkComponents(customItem, null, resolvableComponents::add);
        return new CustomItemContext(customItem, components, resolvableComponents, Optional.empty(), customItemId, protocolVersion);
    }

    private static DataComponents checkComponents(CustomItemDefinition definition, Item javaItem, Consumer<ResolvableComponent<?>> resolvableConsumer) throws InvalidItemComponentsException {
        DataComponents components = CustomItemContext.patchDataComponents(javaItem, definition, resolvableConsumer);
        int stackSize = components.getOrDefault(DataComponentTypes.MAX_STACK_SIZE, 0);
        int maxDamage = components.getOrDefault(DataComponentTypes.MAX_DAMAGE, 0);
        if (components.get(DataComponentTypes.EQUIPPABLE) != null && stackSize > 1) {
            throw new InvalidItemComponentsException("Bedrock doesn't support equippable items with a stack size above 1");
        }
        if (stackSize > 1 && maxDamage > 0) {
            throw new InvalidItemComponentsException("Stack size must be 1 when max damage is above 0");
        }
        return components;
    }

    private static DataComponents patchDataComponents(@Nullable Item javaItem, CustomItemDefinition definition, Consumer<ResolvableComponent<?>> resolvableConsumer) throws InvalidItemComponentsException {
        DataComponents convertedComponents = ComponentConverters.convertComponentPatch(definition.components(), definition.removedComponents(), resolvableConsumer);
        if (javaItem != null) {
            return javaItem.gatherComponents(null, convertedComponents);
        }
        return convertedComponents;
    }
}

