/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.mcprotocollib.network.packet.Packet;

public class PacketRegistryPopulator {
    public static void populate() {
        for (Class<?> clazz : FileUtils.getGeneratedClassesForAnnotation(Translator.class)) {
            Class<?> packet = clazz.getAnnotation(Translator.class).packet();
            GeyserImpl.getInstance().getLogger().debug("Found annotated translator: " + clazz.getCanonicalName() + " : " + packet.getSimpleName());
            try {
                PacketTranslator translator;
                Class<?> targetPacket;
                if (Packet.class.isAssignableFrom(packet)) {
                    targetPacket = packet;
                    translator = (PacketTranslator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Registries.JAVA_PACKET_TRANSLATORS.register(targetPacket, translator);
                    continue;
                }
                if (BedrockPacket.class.isAssignableFrom(packet)) {
                    targetPacket = packet;
                    translator = (PacketTranslator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Registries.BEDROCK_PACKET_TRANSLATORS.register(targetPacket, translator);
                    continue;
                }
                GeyserImpl.getInstance().getLogger().error("Class " + clazz.getCanonicalName() + " is annotated as a translator but has an invalid target packet.");
            }
            catch (Exception e) {
                GeyserImpl.getInstance().getLogger().error("Could not instantiate annotated translator " + clazz.getCanonicalName());
            }
        }
    }
}

