/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.definition;

import com.google.gson.JsonElement;
import java.util.function.BiConsumer;
import org.geysermc.geyser.api.item.custom.v2.CustomItemDefinition;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.registry.mappings.definition.ItemDefinitionReader;
import org.geysermc.geyser.registry.mappings.definition.ItemDefinitionReaders;
import org.geysermc.geyser.registry.mappings.util.MappingsUtil;
import org.geysermc.geyser.registry.mappings.util.NodeReader;

public class GroupDefinitionReader
implements ItemDefinitionReader {
    @Override
    public void readDefinition(JsonElement data, Identifier vanillaItem, Identifier parentModel, BiConsumer<Identifier, CustomItemDefinition> consumer) throws InvalidCustomMappingsFileException {
        String context = "group item definition";
        Identifier groupModel = MappingsUtil.readOrDefault(data, "model", NodeReader.IDENTIFIER, parentModel, context);
        JsonElement definitions = data.getAsJsonObject().get("definitions");
        if (definitions == null || !definitions.isJsonArray()) {
            throw new InvalidCustomMappingsFileException("reading item definitions in group", "group has no definitions key, or it wasn't an array", context);
        }
        for (JsonElement definition : definitions.getAsJsonArray()) {
            ItemDefinitionReaders.readDefinition(definition, vanillaItem, groupModel, consumer, new String[0]);
        }
    }
}

