/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.standalone;

import lombok.Generated;
import net.minecrell.terminalconsole.SimpleTerminalConsole;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.io.IoBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.incendo.cloud.suggestion.Suggestion;
import org.incendo.cloud.suggestion.Suggestions;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeyserStandaloneLogger
extends SimpleTerminalConsole
implements GeyserLogger,
GeyserCommandSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeyserStandaloneLogger.class);
    private static final org.apache.logging.log4j.Logger logger = LogManager.getLogger("GeyserConsole");

    public static void setupStreams() {
        System.setOut(IoBuilder.forLogger(logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger(logger).setLevel(Level.ERROR).buildPrintStream());
    }

    @Override
    protected LineReader buildReader(LineReaderBuilder builder) {
        builder.completer((reader, line, candidates) -> {
            Suggestions<GeyserCommandSource, ? extends Suggestion> suggestions = GeyserImpl.getInstance().commandRegistry().suggestionsFor(this, line.line());
            for (Suggestion suggestion : suggestions.list()) {
                candidates.add(new Candidate(suggestion.suggestion()));
            }
        });
        return super.buildReader(builder);
    }

    @Override
    protected boolean isRunning() {
        return !GeyserImpl.getInstance().isShuttingDown();
    }

    @Override
    protected void runCommand(String line) {
        GeyserImpl geyser = GeyserImpl.getInstance();
        geyser.getScheduledThread().execute(() -> geyser.commandRegistry().runCommand(this, line));
    }

    @Override
    protected void shutdown() {
        GeyserImpl.getInstance().getBootstrap().onGeyserShutdown();
    }

    @Override
    public void severe(String message) {
        log.error("\u00a74" + message);
    }

    @Override
    public void severe(String message, Throwable error) {
        log.error("\u00a74" + message, error);
    }

    @Override
    public void error(String message) {
        log.error("\u00a7c" + message);
    }

    @Override
    public void error(String message, Throwable error) {
        log.error("\u00a7c" + message, error);
    }

    @Override
    public void warning(String message) {
        log.warn("\u00a7e" + message);
    }

    @Override
    public void info(String message) {
        log.info("\u00a7r" + message);
    }

    @Override
    public void debug(String message) {
        log.debug("\u00a77{}", (Object)message);
    }

    @Override
    public void debug(@Nullable Object object) {
        log.debug("{}", object);
    }

    @Override
    public void debug(String message, Object ... arguments) {
        log.debug("\u00a77" + String.format(message, arguments));
    }

    @Override
    public void setDebug(boolean debug) {
        Configurator.setLevel(log.getName(), debug ? Level.DEBUG : Level.INFO);
    }

    @Override
    public boolean isDebug() {
        return log.isDebugEnabled();
    }
}

