/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.standalone;

import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.CommandRegistry;
import org.geysermc.geyser.command.standalone.StandaloneCloudCommandManager;
import org.geysermc.geyser.configuration.ConfigLoader;
import org.geysermc.geyser.configuration.GeyserConfig;
import org.geysermc.geyser.configuration.GeyserRemoteConfig;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.standalone.GeyserStandaloneDumpInfo;
import org.geysermc.geyser.platform.standalone.GeyserStandaloneLogger;
import org.geysermc.geyser.platform.standalone.gui.GeyserStandaloneGUI;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.LoopbackUtil;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.serialize.SerializationException;

public class GeyserStandaloneBootstrap
implements GeyserBootstrap {
    private StandaloneCloudCommandManager cloud;
    private CommandRegistry commandRegistry;
    private GeyserConfig geyserConfig;
    private final GeyserStandaloneLogger geyserLogger = new GeyserStandaloneLogger();
    private IGeyserPingPassthrough geyserPingPassthrough;
    private GeyserStandaloneGUI gui;
    private boolean useGui = System.console() == null && !this.isHeadless();
    private Logger log4jLogger;
    private String configFilename = "config.yml";
    private GeyserImpl geyser;
    private static final Map<NodePath, String> argsConfigKeys = new HashMap<NodePath, String>();

    public static void main(String[] args) {
        if (System.getProperty("io.netty.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        }
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        GeyserStandaloneLogger.setupStreams();
        GeyserStandaloneBootstrap bootstrap = new GeyserStandaloneBootstrap();
        boolean useGuiOpts = bootstrap.useGui;
        String configFilenameOpt = bootstrap.configFilename;
        GeyserLocale.init(bootstrap);
        block16: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "--gui": 
                case "gui": {
                    useGuiOpts = true;
                    continue block16;
                }
                case "--nogui": 
                case "nogui": {
                    useGuiOpts = false;
                    continue block16;
                }
                case "--config": 
                case "-c": {
                    if (i >= args.length - 1) {
                        System.err.println(MessageFormat.format(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.config_not_specified"), "-c"));
                        return;
                    }
                    configFilenameOpt = args[i + 1];
                    ++i;
                    System.out.println(MessageFormat.format(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.config_specified"), configFilenameOpt));
                    continue block16;
                }
                case "--help": 
                case "-h": {
                    System.out.println(MessageFormat.format(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.usage"), "[java -jar] Geyser.jar [opts]"));
                    System.out.println("  " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.options"));
                    System.out.println("    -c, --config [file]    " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.config"));
                    System.out.println("    -h, --help             " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.help"));
                    System.out.println("    --gui, --nogui         " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.gui"));
                    return;
                }
                default: {
                    String[] argParts;
                    if (arg.startsWith("--") && (argParts = arg.substring(2).split("=")).length == 2) {
                        argsConfigKeys.put(NodePath.of(argParts[0].split("\\.")), argParts[1]);
                        continue block16;
                    }
                    System.err.println(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.unrecognised", arg));
                    return;
                }
            }
        }
        bootstrap.useGui = useGuiOpts;
        bootstrap.configFilename = configFilenameOpt;
        bootstrap.onGeyserInitialize();
    }

    @Override
    public void onGeyserInitialize() {
        this.log4jLogger = (Logger)LogManager.getRootLogger();
        if (this.useGui && this.gui == null) {
            this.gui = new GeyserStandaloneGUI(this.geyserLogger);
            this.gui.addGuiAppender();
            this.gui.startUpdateThread();
        }
        LoopbackUtil.checkAndApplyLoopback(this.geyserLogger);
        this.onGeyserEnable();
    }

    @Override
    public void onGeyserEnable() {
        this.geyserConfig = this.loadConfig(GeyserRemoteConfig.class);
        if (this.geyserConfig == null) {
            if (this.gui == null) {
                System.exit(1);
            } else {
                return;
            }
        }
        this.log4jLogger.get().setLevel(this.geyserConfig.debugMode() ? Level.DEBUG : Level.INFO);
        this.geyser = GeyserImpl.load(this);
        boolean reloading = this.geyser.isReloading();
        if (!reloading) {
            this.cloud = new StandaloneCloudCommandManager(this.geyser);
            this.commandRegistry = new CommandRegistry(this.geyser, this.cloud);
        }
        GeyserImpl.start();
        if (!reloading) {
            this.cloud.fireRegisterPermissionsEvent();
        } else {
            this.geyser.setReloading(false);
        }
        if (this.gui != null) {
            this.gui.enableCommands(this.geyser.getScheduledThread(), this.commandRegistry);
        }
        this.geyserPingPassthrough = GeyserLegacyPingPassthrough.init(this.geyser);
        this.geyserLogger.start();
    }

    @Override
    public <T extends GeyserConfig> T loadConfig(Class<T> configClass) {
        return new ConfigLoader(this).configFile(new File(this.configFilename)).transformer(this::handleArgsConfigOptions).load(configClass);
    }

    private boolean isHeadless() {
        try {
            Class<?> graphicsEnv = Class.forName("java.awt.GraphicsEnvironment");
            Method isHeadless = graphicsEnv.getDeclaredMethod("isHeadless", new Class[0]);
            return (Boolean)isHeadless.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void onGeyserDisable() {
        this.geyser.disable();
    }

    @Override
    public void onGeyserShutdown() {
        this.geyser.shutdown();
        System.exit(0);
    }

    @Override
    public @NonNull PlatformType platformType() {
        return PlatformType.STANDALONE;
    }

    @Override
    public GeyserConfig config() {
        return this.geyserConfig;
    }

    @Override
    public GeyserStandaloneLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserPingPassthrough;
    }

    @Override
    public Path getConfigFolder() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    @Override
    public Path getSavedUserLoginsFolder() {
        return new File(this.configFilename).getAbsoluteFile().getParentFile().toPath();
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserStandaloneDumpInfo(this);
    }

    @Override
    public @NonNull String getServerPlatform() {
        return PlatformType.STANDALONE.platformName();
    }

    @Override
    public @NonNull String getServerBindAddress() {
        throw new IllegalStateException();
    }

    @Override
    public int getServerPort() {
        throw new IllegalStateException();
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        return false;
    }

    @Override
    public Path getFloodgateKeyPath() {
        return Path.of(this.geyserConfig.advanced().floodgateKeyFile(), new String[0]);
    }

    private static void setConfigOption(CommentedConfigurationNode node, Object value) throws SerializationException {
        Object parsedValue = value;
        Class<?> clazz = node.raw().getClass();
        if (Integer.class == clazz) {
            parsedValue = Integer.valueOf((String)parsedValue);
        } else if (Boolean.class == clazz) {
            parsedValue = Boolean.valueOf((String)parsedValue);
        }
        node.set(parsedValue);
    }

    private void handleArgsConfigOptions(CommentedConfigurationNode node) {
        for (Map.Entry<NodePath, String> configKey : argsConfigKeys.entrySet()) {
            NodePath path = configKey.getKey();
            CommentedConfigurationNode subNode = (CommentedConfigurationNode)node.node((Iterable)path);
            if (subNode.virtual()) {
                this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.unrecognised", path));
                continue;
            }
            try {
                GeyserStandaloneBootstrap.setConfigOption(subNode, configKey.getValue());
                this.geyserLogger.info(GeyserLocale.getLocaleStringLog("geyser.bootstrap.args.set_config_option", configKey.getKey(), configKey.getValue()));
            }
            catch (SerializationException e) {
                this.geyserLogger.error("Failed to set config option: " + String.valueOf(path));
            }
        }
    }

    @Generated
    public boolean isUseGui() {
        return this.useGui;
    }
}

