/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.api.item.custom.v2.component.geyser;

import java.util.function.Predicate;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.item.custom.v2.component.DataComponent;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.BlockPlacer;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.Chargeable;
import org.geysermc.geyser.api.item.custom.v2.component.geyser.ThrowableComponent;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.api.util.Unit;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface GeyserDataComponent {
    public static final DataComponent<Chargeable> CHARGEABLE = GeyserDataComponent.createGeyser("chargeable");
    public static final DataComponent<Integer> ATTACK_DAMAGE = GeyserDataComponent.createGeyser("attack_damage", i -> i >= 0);
    public static final DataComponent<BlockPlacer> BLOCK_PLACER = GeyserDataComponent.createGeyser("block_placer");
    public static final DataComponent<ThrowableComponent> THROWABLE = GeyserDataComponent.createGeyser("throwable");
    public static final DataComponent<Unit> PROJECTILE = GeyserDataComponent.createGeyser("projectile");
    public static final DataComponent<Unit> ENTITY_PLACER = GeyserDataComponent.createGeyser("entity_placer");

    private static <T> DataComponent<T> createGeyser(String id) {
        return GeyserDataComponent.createGeyser(id, t -> true);
    }

    private static <T> DataComponent<T> createGeyser(String id, Predicate<T> predicate) {
        return (DataComponent)GeyserApi.api().provider(DataComponent.class, Identifier.of("geysermc", id), predicate, false);
    }
}

