/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.api.util;

public class ApiVersion {
    private final int human;
    private final int major;
    private final int minor;

    public ApiVersion(int human, int major, int minor) {
        this.human = human;
        this.major = major;
        this.minor = minor;
    }

    public int human() {
        return this.human;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public Compatibility supportsRequestedVersion(int human, int major, int minor) {
        if (human != this.human) {
            return Compatibility.HUMAN_DIFFER;
        }
        if (major > this.major) {
            return Compatibility.MAJOR_TOO_NEW;
        }
        if (minor > this.minor && major >= this.major) {
            return Compatibility.MINOR_TOO_NEW;
        }
        return Compatibility.COMPATIBLE;
    }

    public String toString() {
        return this.human + "." + this.major + "." + this.minor;
    }

    public static enum Compatibility {
        COMPATIBLE("The api versions are compatible!"),
        HUMAN_DIFFER("The requested human api version does not match!"),
        MAJOR_TOO_NEW("The requested major api version is too high!"),
        MINOR_TOO_NEW("The requested minor api version is too high!");

        private final String reason;

        private Compatibility(String reason) {
            this.reason = reason;
        }

        public String cause() {
            return this.reason;
        }
    }
}

