/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.xbl.model;

import com.google.gson.JsonObject;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.util.Expirable;

public final class XblXstsToken
implements Expirable {
    private final long expireTimeMs;
    private final String token;
    private final String userHash;

    public static XblXstsToken fromJson(JsonObject json) {
        return XblXstsToken.fromJson(new GsonObject(json));
    }

    public static XblXstsToken fromJson(GsonObject json) {
        return new XblXstsToken(json.reqLong("expireTimeMs"), json.reqString("token"), json.reqString("userHash"));
    }

    public static JsonObject toJson(XblXstsToken xstsToken) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", 1);
        json.addProperty("expireTimeMs", xstsToken.expireTimeMs);
        json.addProperty("token", xstsToken.token);
        json.addProperty("userHash", xstsToken.userHash);
        return json;
    }

    public String getAuthorizationHeader() {
        return "XBL3.0 x=" + this.userHash + ';' + this.token;
    }

    @Generated
    public XblXstsToken(long expireTimeMs, String token, String userHash) {
        this.expireTimeMs = expireTimeMs;
        this.token = token;
        this.userHash = userHash;
    }

    @Override
    @Generated
    public long getExpireTimeMs() {
        return this.expireTimeMs;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getUserHash() {
        return this.userHash;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XblXstsToken)) {
            return false;
        }
        XblXstsToken other = (XblXstsToken)o;
        if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$userHash = this.getUserHash();
        String other$userHash = other.getUserHash();
        return !(this$userHash == null ? other$userHash != null : !this$userHash.equals(other$userHash));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expireTimeMs = this.getExpireTimeMs();
        result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $userHash = this.getUserHash();
        result = result * 59 + ($userHash == null ? 43 : $userHash.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "XblXstsToken(expireTimeMs=" + this.getExpireTimeMs() + ", token=" + this.getToken() + ", userHash=" + this.getUserHash() + ")";
    }
}

