/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.util;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.UUID;
import net.lenni0451.commons.gson.elements.GsonElement;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.util.CryptUtil;
import net.raphimc.minecraftauth.util.JsonUtil;

public class MinecraftAuth4To5Migrator {
    public static JsonObject migrateJavaSave(JsonObject oldSaveData) {
        return MinecraftAuth4To5Migrator.migrateJavaSave(oldSaveData, new MsaApplicationConfig("00000000402b5328", "service::user.auth.xboxlive.com::MBI_SSL"));
    }

    public static JsonObject migrateJavaSave(JsonObject oldSaveData, MsaApplicationConfig msaApplicationConfig) {
        String refreshToken = MinecraftAuth4To5Migrator.findRefreshToken(new GsonObject(oldSaveData));
        if (refreshToken == null) {
            throw new IllegalArgumentException("Failed to find refresh token in the provided save data");
        }
        JsonObject newJson = new JsonObject();
        newJson.addProperty("_saveVersion", 1);
        newJson.add("msaApplicationConfig", MsaApplicationConfig.toJson(msaApplicationConfig));
        newJson.addProperty("deviceType", "Win32");
        newJson.add("deviceKeyPair", JsonUtil.encodeKeyPair(CryptUtil.generateEcdsa256KeyPair()));
        newJson.addProperty("deviceId", UUID.randomUUID().toString());
        newJson.add("msaToken", MsaToken.toJson(new MsaToken(0L, "", refreshToken)));
        return newJson;
    }

    public static JsonObject migrateBedrockSave(JsonObject oldSaveData) {
        return MinecraftAuth4To5Migrator.migrateBedrockSave(oldSaveData, new MsaApplicationConfig("0000000048183522", "service::user.auth.xboxlive.com::MBI_SSL"));
    }

    public static JsonObject migrateBedrockSave(JsonObject oldSaveData, MsaApplicationConfig msaApplicationConfig) {
        String refreshToken = MinecraftAuth4To5Migrator.findRefreshToken(new GsonObject(oldSaveData));
        if (refreshToken == null) {
            throw new IllegalArgumentException("Failed to find refresh token in the provided save data");
        }
        JsonObject newJson = new JsonObject();
        newJson.addProperty("_saveVersion", 1);
        newJson.add("msaApplicationConfig", MsaApplicationConfig.toJson(msaApplicationConfig));
        newJson.addProperty("deviceType", "Android");
        newJson.add("deviceKeyPair", JsonUtil.encodeKeyPair(CryptUtil.generateEcdsa256KeyPair()));
        newJson.addProperty("deviceId", UUID.randomUUID().toString());
        newJson.add("sessionKeyPair", JsonUtil.encodeKeyPair(CryptUtil.generateEcdsa384KeyPair()));
        newJson.add("msaToken", MsaToken.toJson(new MsaToken(0L, "", refreshToken)));
        return newJson;
    }

    public static String findRefreshToken(GsonObject json) {
        if (json.hasString("refreshToken")) {
            return json.reqString("refreshToken");
        }
        for (Map.Entry<String, GsonElement> entry : json.entrySet()) {
            String refreshToken;
            if (!entry.getValue().isObject() || (refreshToken = MinecraftAuth4To5Migrator.findRefreshToken(entry.getValue().asObject())) == null) continue;
            return refreshToken;
        }
        return null;
    }
}

