/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.playfab.request;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.time.Instant;
import java.util.Locale;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.playfab.model.PlayFabToken;
import net.raphimc.minecraftauth.playfab.responsehandler.PlayFabResponseHandler;
import net.raphimc.minecraftauth.util.http.content.JsonContent;
import net.raphimc.minecraftauth.xbl.model.XblXstsToken;

public class PlayFabLoginWithXboxRequest
extends PostRequest
implements PlayFabResponseHandler<PlayFabToken> {
    public PlayFabLoginWithXboxRequest(XblXstsToken xstsToken, String titleId) throws MalformedURLException {
        super("https://" + titleId.toLowerCase(Locale.ROOT) + ".playfabapi.com/Client/LoginWithXbox");
        JsonObject infoRequestParameters = new JsonObject();
        infoRequestParameters.addProperty("GetPlayerProfile", true);
        infoRequestParameters.addProperty("GetUserAccountInfo", true);
        JsonObject postData = new JsonObject();
        postData.addProperty("CreateAccount", true);
        postData.add("InfoRequestParameters", infoRequestParameters);
        postData.addProperty("TitleId", titleId.toUpperCase(Locale.ROOT));
        postData.addProperty("XboxToken", xstsToken.getAuthorizationHeader());
        this.setContent(new JsonContent(postData));
    }

    @Override
    public PlayFabToken handle(HttpResponse response, GsonObject json) throws IOException {
        GsonObject data = json.reqObject("data");
        GsonObject entityToken = data.reqObject("EntityToken");
        return new PlayFabToken(Instant.parse(entityToken.reqString("TokenExpiration")).toEpochMilli(), entityToken.reqObject("Entity").reqString("Id"), entityToken.reqString("EntityToken"), data.reqString("PlayFabId"), data.reqString("SessionTicket"));
    }
}

