/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.java.model;

import com.google.gson.JsonObject;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.util.Expirable;
import net.raphimc.minecraftauth.util.JsonUtil;

public final class MinecraftPlayerCertificates
implements Expirable {
    private final long expireTimeMs;
    private final KeyPair keyPair;
    private final byte[] publicKeySignature;
    private final byte[] legacyPublicKeySignature;

    public static MinecraftPlayerCertificates fromJson(JsonObject json) {
        return MinecraftPlayerCertificates.fromJson(new GsonObject(json));
    }

    public static MinecraftPlayerCertificates fromJson(GsonObject json) {
        return new MinecraftPlayerCertificates(json.reqLong("expireTimeMs"), JsonUtil.decodeKeyPair(json.reqObject("keyPair")), Base64.getDecoder().decode(json.reqString("publicKeySignature")), json.optString("legacyPublicKeySignature").map(Base64.getDecoder()::decode).orElse(null));
    }

    public static JsonObject toJson(MinecraftPlayerCertificates playerCertificates) {
        JsonObject json = new JsonObject();
        json.addProperty("_saveVersion", 1);
        json.addProperty("expireTimeMs", playerCertificates.expireTimeMs);
        json.add("keyPair", JsonUtil.encodeKeyPair(playerCertificates.keyPair));
        json.addProperty("publicKeySignature", Base64.getEncoder().encodeToString(playerCertificates.publicKeySignature));
        if (playerCertificates.legacyPublicKeySignature != null) {
            json.addProperty("legacyPublicKeySignature", Base64.getEncoder().encodeToString(playerCertificates.legacyPublicKeySignature));
        }
        return json;
    }

    @Generated
    public MinecraftPlayerCertificates(long expireTimeMs, KeyPair keyPair, byte[] publicKeySignature, byte[] legacyPublicKeySignature) {
        this.expireTimeMs = expireTimeMs;
        this.keyPair = keyPair;
        this.publicKeySignature = publicKeySignature;
        this.legacyPublicKeySignature = legacyPublicKeySignature;
    }

    @Override
    @Generated
    public long getExpireTimeMs() {
        return this.expireTimeMs;
    }

    @Generated
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Generated
    public byte[] getPublicKeySignature() {
        return this.publicKeySignature;
    }

    @Generated
    public byte[] getLegacyPublicKeySignature() {
        return this.legacyPublicKeySignature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinecraftPlayerCertificates)) {
            return false;
        }
        MinecraftPlayerCertificates other = (MinecraftPlayerCertificates)o;
        if (this.getExpireTimeMs() != other.getExpireTimeMs()) {
            return false;
        }
        KeyPair this$keyPair = this.getKeyPair();
        KeyPair other$keyPair = other.getKeyPair();
        if (this$keyPair == null ? other$keyPair != null : !this$keyPair.equals(other$keyPair)) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKeySignature(), other.getPublicKeySignature())) {
            return false;
        }
        return Arrays.equals(this.getLegacyPublicKeySignature(), other.getLegacyPublicKeySignature());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expireTimeMs = this.getExpireTimeMs();
        result = result * 59 + (int)($expireTimeMs >>> 32 ^ $expireTimeMs);
        KeyPair $keyPair = this.getKeyPair();
        result = result * 59 + ($keyPair == null ? 43 : $keyPair.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPublicKeySignature());
        result = result * 59 + Arrays.hashCode(this.getLegacyPublicKeySignature());
        return result;
    }

    @Generated
    public String toString() {
        return "MinecraftPlayerCertificates(expireTimeMs=" + this.getExpireTimeMs() + ", keyPair=" + this.getKeyPair() + ", publicKeySignature=" + Arrays.toString(this.getPublicKeySignature()) + ", legacyPublicKeySignature=" + Arrays.toString(this.getLegacyPublicKeySignature()) + ")";
    }
}

