/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ServerboundSetCreativeModeSlotPacket
implements MinecraftPacket {
    private final short slot;
    private final @Nullable ItemStack clickedItem;

    public ServerboundSetCreativeModeSlotPacket(ByteBuf in) {
        this.slot = in.readShort();
        this.clickedItem = MinecraftTypes.readOptionalItemStack(in, true);
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeShort(this.slot);
        MinecraftTypes.writeOptionalItemStack(out, this.clickedItem, true);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public short getSlot() {
        return this.slot;
    }

    public @Nullable ItemStack getClickedItem() {
        return this.clickedItem;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSetCreativeModeSlotPacket)) {
            return false;
        }
        ServerboundSetCreativeModeSlotPacket other = (ServerboundSetCreativeModeSlotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        ItemStack this$clickedItem = this.getClickedItem();
        ItemStack other$clickedItem = other.getClickedItem();
        return !(this$clickedItem == null ? other$clickedItem != null : !((Object)this$clickedItem).equals(other$clickedItem));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSetCreativeModeSlotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        ItemStack $clickedItem = this.getClickedItem();
        result = result * 59 + ($clickedItem == null ? 43 : ((Object)$clickedItem).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSetCreativeModeSlotPacket(slot=" + this.getSlot() + ", clickedItem=" + String.valueOf(this.getClickedItem()) + ")";
    }

    public @NonNull ServerboundSetCreativeModeSlotPacket withSlot(short slot) {
        return this.slot == slot ? this : new ServerboundSetCreativeModeSlotPacket(slot, this.clickedItem);
    }

    public @NonNull ServerboundSetCreativeModeSlotPacket withClickedItem(@Nullable ItemStack clickedItem) {
        return this.clickedItem == clickedItem ? this : new ServerboundSetCreativeModeSlotPacket(this.slot, clickedItem);
    }

    public ServerboundSetCreativeModeSlotPacket(short slot, @Nullable ItemStack clickedItem) {
        this.slot = slot;
        this.clickedItem = clickedItem;
    }
}

