/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.metadata;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.cloudburstmc.math.imaginary.Quaternionf;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.ArmadilloState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.BooleanMetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.ByteMetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.CopperGolemState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.FloatMetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.GlobalPos;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.IntMetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.LongMetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.OptionalIntMetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.PaintingVariant;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.SnifferState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.VillagerData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.WeatheringCopperState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.FloatEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.LongEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.ResolvableProfile;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.level.particle.Particle;

public class MetadataTypes {
    private static final List<MetadataType<?>> VALUES = new ArrayList();
    public static final ByteMetadataType BYTE = MetadataTypes.register(id -> new ByteMetadataType(id, ByteBuf::readByte, ByteBuf::writeByte, ByteEntityMetadata::new));
    public static final IntMetadataType INT = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final LongMetadataType LONG = MetadataTypes.register(id -> new LongMetadataType(id, MinecraftTypes::readVarLong, MinecraftTypes::writeVarLong, LongEntityMetadata::new));
    public static final FloatMetadataType FLOAT = MetadataTypes.register(id -> new FloatMetadataType(id, ByteBuf::readFloat, ByteBuf::writeFloat, FloatEntityMetadata::new));
    public static final MetadataType<String> STRING = MetadataTypes.register(id -> new MetadataType<String>(id, MinecraftTypes::readString, MinecraftTypes::writeString, ObjectEntityMetadata::new));
    public static final MetadataType<Component> COMPONENT = MetadataTypes.register(id -> new MetadataType<Component>(id, MinecraftTypes::readComponent, MinecraftTypes::writeComponent, ObjectEntityMetadata::new));
    public static final MetadataType<Optional<Component>> OPTIONAL_COMPONENT = MetadataTypes.register(id -> new MetadataType<Optional>(id, MetadataTypes.optionalReader(MinecraftTypes::readComponent), MetadataTypes.optionalWriter(MinecraftTypes::writeComponent), ObjectEntityMetadata::new));
    public static final MetadataType<ItemStack> ITEM_STACK = MetadataTypes.register(id -> new MetadataType<ItemStack>(id, MinecraftTypes::readOptionalItemStack, MinecraftTypes::writeOptionalItemStack, ObjectEntityMetadata::new));
    public static final BooleanMetadataType BOOLEAN = MetadataTypes.register(id -> new BooleanMetadataType(id, ByteBuf::readBoolean, ByteBuf::writeBoolean, BooleanEntityMetadata::new));
    public static final MetadataType<Vector3f> ROTATIONS = MetadataTypes.register(id -> new MetadataType<Vector3f>(id, MinecraftTypes::readRotation, MinecraftTypes::writeRotation, ObjectEntityMetadata::new));
    public static final MetadataType<Vector3i> BLOCK_POS = MetadataTypes.register(id -> new MetadataType<Vector3i>(id, MinecraftTypes::readPosition, MinecraftTypes::writePosition, ObjectEntityMetadata::new));
    public static final MetadataType<Optional<Vector3i>> OPTIONAL_BLOCK_POS = MetadataTypes.register(id -> new MetadataType<Optional>(id, MetadataTypes.optionalReader(MinecraftTypes::readPosition), MetadataTypes.optionalWriter(MinecraftTypes::writePosition), ObjectEntityMetadata::new));
    public static final MetadataType<Direction> DIRECTION = MetadataTypes.register(id -> new MetadataType<Direction>(id, MinecraftTypes::readDirection, MinecraftTypes::writeDirection, ObjectEntityMetadata::new));
    public static final MetadataType<Optional<UUID>> OPTIONAL_LIVING_ENTITY_REFERENCE = MetadataTypes.register(id -> new MetadataType<Optional>(id, MetadataTypes.optionalReader(MinecraftTypes::readUUID), MetadataTypes.optionalWriter(MinecraftTypes::writeUUID), ObjectEntityMetadata::new));
    public static final IntMetadataType BLOCK_STATE = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final IntMetadataType OPTIONAL_BLOCK_STATE = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final MetadataType<Particle> PARTICLE = MetadataTypes.register(id -> new MetadataType<Particle>(id, MinecraftTypes::readParticle, MinecraftTypes::writeParticle, ObjectEntityMetadata::new));
    public static final MetadataType<List<Particle>> PARTICLES = MetadataTypes.register(id -> new MetadataType<List>(id, MetadataTypes.listReader(MinecraftTypes::readParticle), MetadataTypes.listWriter(MinecraftTypes::writeParticle), ObjectEntityMetadata::new));
    public static final MetadataType<VillagerData> VILLAGER_DATA = MetadataTypes.register(id -> new MetadataType<VillagerData>(id, MinecraftTypes::readVillagerData, MinecraftTypes::writeVillagerData, ObjectEntityMetadata::new));
    public static final OptionalIntMetadataType OPTIONAL_UNSIGNED_INT = MetadataTypes.register(id -> new OptionalIntMetadataType(id, ObjectEntityMetadata::new));
    public static final MetadataType<Pose> POSE = MetadataTypes.register(id -> new MetadataType<Pose>(id, MinecraftTypes::readPose, MinecraftTypes::writePose, ObjectEntityMetadata::new));
    public static final IntMetadataType CAT_VARIANT = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final IntMetadataType COW_VARIANT = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final IntMetadataType WOLF_VARIANT = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final IntMetadataType WOLF_SOUND_VARIANT = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final IntMetadataType FROG_VARIANT = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final IntMetadataType PIG_VARIANT = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final IntMetadataType CHICKEN_VARIANT = MetadataTypes.register(id -> new IntMetadataType(id, MinecraftTypes::readVarInt, MinecraftTypes::writeVarInt, IntEntityMetadata::new));
    public static final MetadataType<Optional<GlobalPos>> OPTIONAL_GLOBAL_POS = MetadataTypes.register(id -> new MetadataType<Optional>(id, MetadataTypes.optionalReader(MinecraftTypes::readGlobalPos), MetadataTypes.optionalWriter(MinecraftTypes::writeGlobalPos), ObjectEntityMetadata::new));
    public static final MetadataType<Holder<PaintingVariant>> PAINTING_VARIANT = MetadataTypes.register(id -> new MetadataType<Holder>(id, MinecraftTypes::readPaintingVariant, MinecraftTypes::writePaintingVariant, ObjectEntityMetadata::new));
    public static final MetadataType<SnifferState> SNIFFER_STATE = MetadataTypes.register(id -> new MetadataType<SnifferState>(id, MinecraftTypes::readSnifferState, MinecraftTypes::writeSnifferState, ObjectEntityMetadata::new));
    public static final MetadataType<ArmadilloState> ARMADILLO_STATE = MetadataTypes.register(id -> new MetadataType<ArmadilloState>(id, MinecraftTypes::readArmadilloState, MinecraftTypes::writeArmadilloState, ObjectEntityMetadata::new));
    public static final MetadataType<CopperGolemState> COPPER_GOLEM_STATE = MetadataTypes.register(id -> new MetadataType<CopperGolemState>(id, MinecraftTypes::readCopperGolemState, MinecraftTypes::writeCopperGolemState, ObjectEntityMetadata::new));
    public static final MetadataType<WeatheringCopperState> WEATHERING_COPPER_STATE = MetadataTypes.register(id -> new MetadataType<WeatheringCopperState>(id, MinecraftTypes::readWeatheringCopperState, MinecraftTypes::writeWeatheringCopperState, ObjectEntityMetadata::new));
    public static final MetadataType<Vector3f> VECTOR3 = MetadataTypes.register(id -> new MetadataType<Vector3f>(id, MinecraftTypes::readRotation, MinecraftTypes::writeRotation, ObjectEntityMetadata::new));
    public static final MetadataType<Quaternionf> QUATERNION = MetadataTypes.register(id -> new MetadataType<Quaternionf>(id, MinecraftTypes::readQuaternion, MinecraftTypes::writeQuaternion, ObjectEntityMetadata::new));
    public static final MetadataType<ResolvableProfile> RESOLVABLE_PROFILE = MetadataTypes.register(id -> new MetadataType<ResolvableProfile>(id, MinecraftTypes::readResolvableProfile, MinecraftTypes::writeResolvableProfile, ObjectEntityMetadata::new));

    public static <T extends MetadataType<?>> T register(Int2ObjectFunction<T> factory) {
        MetadataType value = (MetadataType)factory.apply(VALUES.size());
        VALUES.add(value);
        return (T)value;
    }

    private static <T> MetadataType.BasicReader<Optional<T>> optionalReader(MetadataType.BasicReader<T> reader) {
        return input -> {
            if (!input.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(reader.read(input));
        };
    }

    private static <T> MetadataType.Reader<Optional<T>> optionalReader(MetadataType.Reader<T> reader) {
        return input -> {
            if (!input.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(reader.read(input));
        };
    }

    private static <T> MetadataType.BasicWriter<Optional<T>> optionalWriter(MetadataType.BasicWriter<T> writer) {
        return (output, value) -> {
            output.writeBoolean(value.isPresent());
            value.ifPresent(t -> writer.write(output, t));
        };
    }

    private static <T> MetadataType.Writer<Optional<T>> optionalWriter(MetadataType.Writer<T> writer) {
        return (output, value) -> {
            output.writeBoolean(value.isPresent());
            value.ifPresent(t -> writer.write(output, t));
        };
    }

    private static <T> MetadataType.Reader<List<T>> listReader(MetadataType.Reader<T> reader) {
        return input -> {
            ArrayList ret = new ArrayList();
            int size = MinecraftTypes.readVarInt(input);
            for (int i = 0; i < size; ++i) {
                ret.add(reader.read(input));
            }
            return ret;
        };
    }

    private static <T> MetadataType.Writer<List<T>> listWriter(MetadataType.Writer<T> writer) {
        return (output, value) -> {
            MinecraftTypes.writeVarInt(output, value.size());
            for (Object object : value) {
                writer.write(output, object);
            }
        };
    }

    public static MetadataType<?> read(ByteBuf in) {
        int id = MinecraftTypes.readVarInt(in);
        if (id >= VALUES.size()) {
            throw new IllegalArgumentException("Received id " + id + " for MetadataType when the maximum was " + VALUES.size() + "!");
        }
        return VALUES.get(id);
    }

    public static MetadataType<?> from(int id) {
        return VALUES.get(id);
    }

    public static int size() {
        return VALUES.size();
    }
}

