/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.geysermc.mcprotocollib.network.NetworkConstants;
import org.geysermc.mcprotocollib.network.crypt.EncryptionConfig;

public class PacketEncryptorCodec
extends ByteToMessageCodec<ByteBuf> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        EncryptionConfig config = ctx.channel().attr(NetworkConstants.ENCRYPTION_ATTRIBUTE_KEY).get();
        if (config == null) {
            out.writeBytes(msg);
            return;
        }
        ByteBuf heapBuf = this.ensureHeapBuffer(ctx.alloc(), msg);
        int inBytes = heapBuf.readableBytes();
        int baseOffset = heapBuf.arrayOffset() + heapBuf.readerIndex();
        try {
            config.encryption().encrypt(heapBuf.array(), baseOffset, inBytes, heapBuf.array(), baseOffset);
            out.writeBytes(heapBuf);
        }
        finally {
            heapBuf.release();
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        EncryptionConfig config = ctx.channel().attr(NetworkConstants.ENCRYPTION_ATTRIBUTE_KEY).get();
        if (config == null) {
            out.add(in.readBytes(in.readableBytes()));
            return;
        }
        ByteBuf heapBuf = this.ensureHeapBuffer(ctx.alloc(), in).slice();
        int inBytes = heapBuf.readableBytes();
        int baseOffset = heapBuf.arrayOffset() + heapBuf.readerIndex();
        try {
            config.encryption().decrypt(heapBuf.array(), baseOffset, inBytes, heapBuf.array(), baseOffset);
            out.add(heapBuf);
            if (in.hasArray()) {
                in.readerIndex(inBytes);
            }
        }
        catch (Exception e) {
            heapBuf.release();
            throw e;
        }
    }

    private ByteBuf ensureHeapBuffer(ByteBufAllocator alloc, ByteBuf buf) {
        if (buf.hasArray()) {
            return buf.retain();
        }
        ByteBuf heapBuf = alloc.heapBuffer(buf.readableBytes());
        heapBuf.writeBytes(buf);
        return heapBuf;
    }
}

